/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.config.tmpl.export;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.core.common.api.ApiResult;
import com.elitescloud.boot.excel.common.param.ImportRecordDTO;
import com.elitescloud.boot.excel.common.support.TmplApiService;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.support.app.CloudtAppHolder;
import com.elitescloud.boot.util.LimiterUtil;
import com.elitescloud.cloudt.system.dto.SysImportRateDTO;
import com.elitescloud.cloudt.system.dto.SysTmplDTO;
import com.elitescloud.cloudt.system.dto.req.RecordResultSaveDTO;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.validation.constraints.NotBlank;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

public class SystemTmplDataSupport {
    private static final Logger log = LogManager.getLogger(SystemTmplDataSupport.class);
    private final TmplApiService tmplApiService;
    private final RedisUtils redisUtils;
    private final FileService<?> fileService;
    private final LimiterUtil limiterUtil;
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    private static final String CACHE_KEY_IMPORT_RATE_PREFIX = "cloudt:tmpl_imp:rate:";

    public SystemTmplDataSupport(TmplApiService tmplApiService, RedisUtils redisUtils, FileService<?> fileService) {
        this.tmplApiService = tmplApiService;
        this.redisUtils = redisUtils;
        this.fileService = fileService;
        this.limiterUtil = LimiterUtil.getInstance((RedisTemplate)redisUtils.getRedisTemplate(), (String)"tmpl_data");
    }

    public HttpEntity<StreamingResponseBody> downloadByCode(String code) {
        return this.tmplApiService.downloadByCode(code);
    }

    public SysTmplDTO getTmplByCode(@NotBlank String code) {
        String cacheKey = "system:tmpl:{TMPL_CODE}".replace("{TMPL_CODE}", code);
        SysTmplDTO tmplDTO = null;
        try {
            tmplDTO = this.redisDefault(() -> (SysTmplDTO)this.redisUtils.get(cacheKey));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528redis\u67e5\u8be2\u6a21\u677f\u4fe1\u606f{}\u5f02\u5e38\uff1a", (Object)code, (Object)e);
        }
        if (tmplDTO != null) {
            return tmplDTO;
        }
        com.elitescloud.cloudt.common.base.ApiResult<SysTmplDTO> result = this.tmplApiService.getByCode(code);
        if (result == null || !result.isSuccess()) {
            log.error("\u67e5\u8be2\u6a21\u677f\u3010{}\u3011\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)code, result);
            throw new BusinessException("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u5931\u8d25");
        }
        this.redisDefault(() -> this.redisUtils.set(cacheKey, result.getData()));
        return (SysTmplDTO)result.getData();
    }

    public Long saveRecord(@NotBlank String code, MultipartFile dataFile, Map<String, Object> queryParam) {
        com.elitescloud.cloudt.common.base.ApiResult<Long> saveResult;
        String fileCode = null;
        if (dataFile != null) {
            if (this.fileService == null) {
                throw new BusinessException("\u6587\u4ef6\u670d\u52a1\u672a\u914d\u7f6e");
            }
            ApiResult uploadResult = this.fileService.upload(dataFile, Collections.emptyMap());
            if (!uploadResult.isSuccess() || uploadResult.getData() == null) {
                log.error("\u4e0a\u4f20\u5bfc\u5165\u6587\u4ef6\u5931\u8d25\uff1a{}", (Object)uploadResult);
                throw new BusinessException("\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u6b63\u5e38");
            }
            fileCode = ((FileObjRespVO)uploadResult.getData()).getFileCode();
        }
        if (!(saveResult = this.tmplApiService.saveRecord(code, fileCode, (Map)ObjectUtil.defaultIfNull(queryParam, Collections.emptyMap()))).isSuccess()) {
            log.error("\u4fdd\u5b58\u6a21\u677f\u3010{}\u3011\u5bfc\u5165\u5bfc\u51fa\u6570\u636e\u8bb0\u5f55\u5931\u8d25\uff1a{}", (Object)code, saveResult);
            throw new BusinessException(saveResult.getMsg());
        }
        return (Long)saveResult.getData();
    }

    public boolean updateLimiter(SysTmplDTO tmplDTO, boolean add) {
        if (tmplDTO.getConcurrentLimit() == null || tmplDTO.getConcurrentLimit() == -1) {
            return true;
        }
        return this.limiterUtil.updateLimiter(tmplDTO.getConcurrentLimit().intValue(), 1, add);
    }

    public void updateImportNum(Long recordId, Long numTotal) {
        com.elitescloud.cloudt.common.base.ApiResult<Long> result = this.tmplApiService.updateNumTotal(recordId, numTotal);
        if (result == null || !result.isSuccess()) {
            throw new BusinessException("\u66f4\u65b0\u64cd\u4f5c\u8bb0\u5f55\u5931\u8d25");
        }
    }

    public void updateImportResult(RecordResultSaveDTO importResultDTO) {
        com.elitescloud.cloudt.common.base.ApiResult<Long> result = this.tmplApiService.updateResult(importResultDTO);
        if (result == null || !result.isSuccess()) {
            throw new BusinessException("\u66f4\u65b0\u5bfc\u5165\u7ed3\u679c\u5931\u8d25");
        }
    }

    public Long saveExportFile(Long recordId, String fileCode, int order) {
        com.elitescloud.cloudt.common.base.ApiResult<Long> result = this.tmplApiService.saveExportFile(recordId, fileCode, order);
        if (result == null || !result.isSuccess()) {
            log.error("\u4fdd\u5b58\u6a21\u677f\u3010{}, {}\u3011\u5bfc\u51fa\u6570\u636e\u8bb0\u5f55\u5931\u8d25\uff1a{}", (Object)recordId, (Object)order, result);
            throw new BusinessException("\u4fdd\u5b58\u5bfc\u51fa\u8bb0\u5f55\u5931\u8d25");
        }
        return (Long)result.getData();
    }

    public void saveImportFailRecord(Long recordId, String fileCode) {
        if (recordId == null || CharSequenceUtil.isBlank((CharSequence)fileCode)) {
            return;
        }
        com.elitescloud.cloudt.common.base.ApiResult<Long> res = this.tmplApiService.saveImportFailRecord(recordId, fileCode);
        if (res.isFailed()) {
            log.error("\u4fdd\u5b58\u5bfc\u5165{}\u5931\u8d25\u7684\u8bb0\u5f55{}\u5931\u8d25\uff1a{}", (Object)recordId, (Object)fileCode, (Object)res.getMsg());
        }
    }

    public void storeRate(Long recordId, SysImportRateDTO rateDTO) {
        String key = CACHE_KEY_IMPORT_RATE_PREFIX + recordId;
        this.redisUtils.set(key, (Object)rateDTO, Duration.ofMinutes(20L).toSeconds());
    }

    public void removeRate(Long recordId) {
        String key = CACHE_KEY_IMPORT_RATE_PREFIX + recordId;
        this.redisUtils.del(new String[]{key});
    }

    public SysImportRateDTO getImportRateFromCache(Long recordId) {
        return (SysImportRateDTO)this.redisUtils.get(CACHE_KEY_IMPORT_RATE_PREFIX + recordId);
    }

    public SysImportRateDTO getImportRate(Long recordId) {
        com.elitescloud.cloudt.common.base.ApiResult<SysImportRateDTO> result = this.tmplApiService.getImportRate(recordId);
        if (result == null || !result.isSuccess()) {
            log.error("\u67e5\u8be2\u5bfc\u5165\u8fdb\u5ea6\u3010{}\u3011\u5931\u8d25\uff1a{}", (Object)recordId, result);
            throw new BusinessException("\u67e5\u8be2\u5bfc\u5165\u8fdb\u5ea6\u5931\u8d25");
        }
        return (SysImportRateDTO)result.getData();
    }

    public String getRecordFileCode(Long recordId) {
        com.elitescloud.cloudt.common.base.ApiResult<String> result = this.tmplApiService.getRecordFileCode(recordId);
        if (result == null || !result.isSuccess()) {
            log.error("\u67e5\u8be2\u8bb0\u5f55\u7684\u6587\u4ef6\u7f16\u53f7\u3010{}\u3011\u5931\u8d25\uff1a{}", (Object)recordId, result);
            throw new BusinessException("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
        }
        return (String)result.getData();
    }

    public List<Long> getUnFinished() {
        com.elitescloud.cloudt.common.base.ApiResult<List<Long>> result = this.tmplApiService.queryUnFinished(null);
        if (result == null || !result.isSuccess()) {
            log.error("\u67e5\u8be2\u672a\u5bfc\u5165\u7ed3\u675f\u7684\u5931\u8d25\uff1a{}", result);
            throw new BusinessException("\u67e5\u8be2\u672a\u5bfc\u5165\u7ed3\u675f\u7684\u5931\u8d25");
        }
        return (List)result.getData();
    }

    public void updateResultForSysError(String failMsg) {
        String appCode = CloudtAppHolder.getAppCode();
        com.elitescloud.cloudt.common.base.ApiResult<Boolean> res = this.tmplApiService.updateResultForError(appCode, failMsg);
        if (res.isFailed()) {
            log.error("\u66f4\u65b0\u5bfc\u5165\u5f02\u5e38\u7ed3\u679c\u5931\u8d25\uff1a{}", (Object)res.getMsg());
        }
    }

    public List<ImportRecordDTO> queryRecord(@NotBlank String tmplCode, Integer hours, Boolean self) {
        return (List)this.tmplApiService.queryRecord(tmplCode, hours, self).computeData();
    }

    private <T> T redisDefault(Supplier<T> supplier) {
        return (T)this.tenantDataIsolateProvider.byDefaultDirectly(supplier);
    }

    @Autowired
    public void setTenantDataIsolateProvider(TenantDataIsolateProvider tenantDataIsolateProvider) {
        this.tenantDataIsolateProvider = tenantDataIsolateProvider;
    }
}

