/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.config.tmpl.export.strategy;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.core.common.api.ApiResult;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.boot.excel.config.tmpl.export.ExportStrategyParam;
import com.elitescloud.boot.excel.config.tmpl.export.SystemTmplDataSupport;
import com.elitescloud.boot.excel.config.tmpl.export.strategy.ExportStrategy;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.cloudt.system.dto.SysImportRateDTO;
import com.elitescloud.cloudt.system.dto.SysTmplDTO;
import com.elitescloud.cloudt.system.dto.req.RecordResultSaveDTO;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.ss.SpreadsheetVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

abstract class BaseExportStrategy<R extends Serializable, P extends AbstractOrderQueryParam>
implements ExportStrategy<R, P> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseExportStrategy.class);
    protected static final Integer SHEET_ROW_MAX = 1000000;
    protected final FileService<?> fileService;
    protected final SystemTmplDataSupport fsmTmplSupport;
    protected final ObjectMapper objectMapper;

    protected BaseExportStrategy(FileService<?> fileService, SystemTmplDataSupport fsmTmplSupport, ObjectMapper objectMapper) {
        this.fileService = fileService;
        this.fsmTmplSupport = fsmTmplSupport;
        this.objectMapper = objectMapper;
    }

    protected List<List<String>> obtainHeaders(SysTmplDTO tmplDTO) {
        Assert.notEmpty(tmplDTO.getAttributes(), (String)"\u672a\u83b7\u53d6\u5230\u6a21\u677f\u7684\u5934\u90e8\u4fe1\u606f");
        return tmplDTO.getAttributes().subList(0, tmplDTO.getFieldTypeRow() - 1);
    }

    protected List<String> obtainAttributes(SysTmplDTO tmplDTO) {
        Assert.notEmpty(tmplDTO.getAttributes(), (String)"\u672a\u83b7\u53d6\u5230\u6a21\u677f\u7684\u5934\u90e8\u4fe1\u606f");
        return tmplDTO.getAttributes().get(tmplDTO.getFieldTypeRow() - 1);
    }

    protected void updateRate(long recordId, SysImportRateDTO rateDTO) {
        this.fsmTmplSupport.storeRate(recordId, rateDTO);
    }

    protected void updateExportFinish(ExportStrategyParam<R, P> param, Long numSuc, String msg) {
        this.updateExportFinish(param, numSuc, msg, null);
    }

    protected void updateExportFinish(ExportStrategyParam<R, P> param, Long numSuc, String msg, File file) {
        if (param.getImportId() != null) {
            String fileCode = this.uploadImportFile(file);
            RecordResultSaveDTO importResultDTO = RecordResultSaveDTO.builder().recordId(param.getImportId()).success(CharSequenceUtil.isBlank((CharSequence)msg)).numSuc(numSuc).failMsg(msg).fileCode(fileCode).build();
            this.fsmTmplSupport.updateImportResult(importResultDTO);
        } else {
            LOG.error("\u66f4\u65b0\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55\u7ed3\u679c\u5931\u8d25\uff1a{}", (Object)msg);
        }
        this.fsmTmplSupport.removeRate(param.getImportId());
        this.fsmTmplSupport.updateLimiter(param.getTmplDTO(), false);
    }

    protected void updateExportFile(ExportStrategyParam<R, P> param, File file, int fileIndex) {
        String fileCode = this.uploadImportFile(file);
        this.fsmTmplSupport.saveExportFile(param.getImportId(), fileCode, fileIndex);
    }

    protected List<List<String>> convertExportData(List<R> dataList, List<String> fields) {
        return ((List)this.objectMapper.convertValue(dataList, (TypeReference)new TypeReference<List<Map<String, Object>>>(){})).stream().map(data -> fields.stream().map(field -> this.obtainValue((Map<String, Object>)data, (String)field)).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private String uploadImportFile(File file) {
        if (file != null) {
            if (file.length() == 0L) {
                LOG.error("\u4e0a\u4f20\u5bfc\u5165\u5bfc\u51fa\u7ed3\u679c\u6587\u4ef6\u5f02\u5e38\uff0c\u6587\u4ef6{}\u4e3a\u7a7a\uff01", (Object)file.getAbsolutePath());
                return null;
            }
            ApiResult uploadResult = this.fileService.upload(file);
            file.delete();
            if (uploadResult.isSuccess()) {
                return ((FileObjRespVO)uploadResult.getData()).getFileCode();
            }
            LOG.error("\u4e0a\u4f20\u5bfc\u5165\u5bfc\u51fa\u7ed3\u679c\u6587\u4ef6\u5931\u8d25\uff1a{}", (Object)uploadResult);
        }
        return null;
    }

    private String obtainValue(Map<String, Object> data, String field) {
        if (StrUtil.isBlank((CharSequence)field)) {
            return "";
        }
        Object value = data.get(field);
        if (value == null) {
            return "";
        }
        if (value instanceof LocalDateTime) {
            return DatetimeUtil.FORMATTER_DATETIME.format((LocalDateTime)value);
        }
        if (value instanceof LocalDate) {
            return DatetimeUtil.FORMATTER_DATE.format((LocalDate)value);
        }
        if (value instanceof Date) {
            return DatetimeUtil.FORMAT_DATETIME.format((Date)value);
        }
        if (value instanceof Double) {
            return NumberUtil.decimalFormatMoney((double)((Double)value));
        }
        if (value instanceof Float) {
            return NumberUtil.decimalFormatMoney((double)((Float)value).floatValue());
        }
        return CharSequenceUtil.subPre((CharSequence)value.toString(), (int)SpreadsheetVersion.EXCEL2007.getMaxTextLength());
    }

    protected File createExportFile(ExportStrategyParam<R, P> param) {
        return this.createExportFile(param, null);
    }

    protected File createExportFile(ExportStrategyParam<R, P> param, Integer order) {
        File fileDir;
        Object fileName = param.getExportFileName();
        if (order != null) {
            fileName = (String)fileName + "_" + order;
        }
        if (!(fileDir = new File(System.getProperty("java.io.tmpdir") + File.separator + LocalDateTime.now().format(DatetimeUtil.FORMATTER_DATETIME_LONG))).exists() && !fileDir.mkdirs()) {
            throw new IllegalStateException("\u5bfc\u51fa\u5f02\u5e38\uff0c\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5939" + fileDir.getAbsolutePath() + "\u5931\u8d25");
        }
        File file = new File(fileDir, (String)fileName + ".xlsx");
        file.delete();
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25", e);
        }
        return file;
    }

    protected int sheetLimit(SysTmplDTO tmplDTO) {
        Integer limit = tmplDTO.getExportSheetLimit();
        if (limit == null) {
            return SHEET_ROW_MAX;
        }
        if (limit > 0 && limit <= SHEET_ROW_MAX) {
            return limit;
        }
        throw new IllegalArgumentException(tmplDTO.getCode() + "\u53c2\u6570" + limit + "\u4e0d\u5408\u6cd5");
    }
}

