package com.elitescloud.boot.jpa.config.auditing;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.security.core.userdetails.UserDetails;

import javax.annotation.Nonnull;

/**
 * 用户操作审计配置.
 *
 * @author Kaiser（wang shao）
 * @date 2021/6/9
 */
@EnableJpaAuditing
@Import(AuditConfig.CustomAuditHandlerRegistrar.class)
@ConditionalOnClass({UserDetails.class})
public class AuditConfig {

    static class CustomAuditHandlerRegistrar implements ImportBeanDefinitionRegistrar {

        @Override
        public void registerBeanDefinitions(@Nonnull AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            registry.registerBeanDefinition("jpaAuditingHandler",
                    BeanDefinitionBuilder.rootBeanDefinition(CustomAuditHandler.class)
                            .addConstructorArgReference("jpaMappingContext")
                            .getBeanDefinition()
            );
        }
    }
}
