package com.elitescloud.boot.jpa;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.io.Serializable;

/**
 * JPA属性配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/8
 */
@ConfigurationProperties(prefix = CloudtJpaProperties.CONFIG_PREFIX)
public class CloudtJpaProperties {
    public static final String CONFIG_PREFIX = "elitesland.jpa";

    @NestedConfigurationProperty
    private Blaze blaze = new Blaze();

    public Blaze getBlaze() {
        return blaze;
    }

    public void setBlaze(Blaze blaze) {
        this.blaze = blaze;
    }

    /**
     * Blaze属性配置，可参考 <a href="https://persistence.blazebit.com/documentation/1.6/core/manual/en_US/#configuration">属性配置</a>
     */
    public static class Blaze implements Serializable {
        private static final long serialVersionUID = -7987000513223290434L;

        /**
         * 是否启用JPA的兼容模式
         */
        private Boolean compatibleMode = true;

        /**
         * 返回结果是否大小写敏感，PostgreSQL要求false
         */
        private Boolean returningClauseCaseSensitive = true;

        /**
         * 处理count语句不正确时将size的值放到count
         */
        private Boolean sizeToCountTransformation = true;

        /**
         * 是否将select中非聚合的表达式自动添加到group by 中
         */
        private Boolean implicitGroupByFromSelect = false;

        /**
         * 是否将having中非聚合的表达式自动添加到group
         */
        private Boolean implicitGroupByFromHaving = false;

        /**
         * 是否将order by中非聚合的表达式自动添加到group
         */
        private Boolean implicitGroupByFromOrderBy = false;

        /**
         * 是否优化表达式
         */
        private Boolean expressionOptimization = true;

        /**
         * 缓存的实现类
         */
        private String cacheClass = "com.blazebit.persistence.parser.expression.ConcurrentHashMapExpressionCache";

        /**
         * 是否过滤掉子句中null值
         */
        private Boolean filterNulls = true;

        /**
         * 无法推断类型时是否始终作为参数
         */
        private Boolean parameterLiteralRendering = true;

        /**
         * 是否以优化的形式呈现以便数据库优化器更倾向于使用索引
         */
        private Boolean optimizedKeysetPredicateRendering = true;

        /**
         * 在分页查询时自动生成Id Query，可取值true、false、auto
         */
        private String inlineIdQuery = "auto";

        /**
         * 在分页查询时自动在查询语句中加入count语句，可取值true、false、auto
         */
        private String inlineCountQuery = "auto";

        /**
         * 非递归的ctes是否默认内联到查询中，可取值true、false、auto
         */
        private String inlineCtes = "true";

        /**
         * 查询计划缓存
         */
        private Boolean queryPlanCacheEnabled = true;

        /**
         * 反向包装
         */
        private Boolean criteriaNegationWrapper = true;

        /**
         * 传递给jpa CriteraBuilder API的值是否应该呈现为参数
         */
        private Boolean criteriaValueAsParameter = true;

        public Boolean getCompatibleMode() {
            return compatibleMode;
        }

        public void setCompatibleMode(Boolean compatibleMode) {
            this.compatibleMode = compatibleMode;
        }

        public Boolean getReturningClauseCaseSensitive() {
            return returningClauseCaseSensitive;
        }

        public void setReturningClauseCaseSensitive(Boolean returningClauseCaseSensitive) {
            this.returningClauseCaseSensitive = returningClauseCaseSensitive;
        }

        public Boolean getSizeToCountTransformation() {
            return sizeToCountTransformation;
        }

        public void setSizeToCountTransformation(Boolean sizeToCountTransformation) {
            this.sizeToCountTransformation = sizeToCountTransformation;
        }

        public Boolean getImplicitGroupByFromSelect() {
            return implicitGroupByFromSelect;
        }

        public void setImplicitGroupByFromSelect(Boolean implicitGroupByFromSelect) {
            this.implicitGroupByFromSelect = implicitGroupByFromSelect;
        }

        public Boolean getImplicitGroupByFromHaving() {
            return implicitGroupByFromHaving;
        }

        public void setImplicitGroupByFromHaving(Boolean implicitGroupByFromHaving) {
            this.implicitGroupByFromHaving = implicitGroupByFromHaving;
        }

        public Boolean getImplicitGroupByFromOrderBy() {
            return implicitGroupByFromOrderBy;
        }

        public void setImplicitGroupByFromOrderBy(Boolean implicitGroupByFromOrderBy) {
            this.implicitGroupByFromOrderBy = implicitGroupByFromOrderBy;
        }

        public Boolean getExpressionOptimization() {
            return expressionOptimization;
        }

        public void setExpressionOptimization(Boolean expressionOptimization) {
            this.expressionOptimization = expressionOptimization;
        }

        public String getCacheClass() {
            return cacheClass;
        }

        public void setCacheClass(String cacheClass) {
            this.cacheClass = cacheClass;
        }

        public Boolean getFilterNulls() {
            return filterNulls;
        }

        public void setFilterNulls(Boolean filterNulls) {
            this.filterNulls = filterNulls;
        }

        public Boolean getParameterLiteralRendering() {
            return parameterLiteralRendering;
        }

        public void setParameterLiteralRendering(Boolean parameterLiteralRendering) {
            this.parameterLiteralRendering = parameterLiteralRendering;
        }

        public Boolean getOptimizedKeysetPredicateRendering() {
            return optimizedKeysetPredicateRendering;
        }

        public void setOptimizedKeysetPredicateRendering(Boolean optimizedKeysetPredicateRendering) {
            this.optimizedKeysetPredicateRendering = optimizedKeysetPredicateRendering;
        }

        public String getInlineIdQuery() {
            return inlineIdQuery;
        }

        public void setInlineIdQuery(String inlineIdQuery) {
            this.inlineIdQuery = inlineIdQuery;
        }

        public String getInlineCountQuery() {
            return inlineCountQuery;
        }

        public void setInlineCountQuery(String inlineCountQuery) {
            this.inlineCountQuery = inlineCountQuery;
        }

        public String getInlineCtes() {
            return inlineCtes;
        }

        public void setInlineCtes(String inlineCtes) {
            this.inlineCtes = inlineCtes;
        }

        public Boolean getQueryPlanCacheEnabled() {
            return queryPlanCacheEnabled;
        }

        public void setQueryPlanCacheEnabled(Boolean queryPlanCacheEnabled) {
            this.queryPlanCacheEnabled = queryPlanCacheEnabled;
        }

        public Boolean getCriteriaNegationWrapper() {
            return criteriaNegationWrapper;
        }

        public void setCriteriaNegationWrapper(Boolean criteriaNegationWrapper) {
            this.criteriaNegationWrapper = criteriaNegationWrapper;
        }

        public Boolean getCriteriaValueAsParameter() {
            return criteriaValueAsParameter;
        }

        public void setCriteriaValueAsParameter(Boolean criteriaValueAsParameter) {
            this.criteriaValueAsParameter = criteriaValueAsParameter;
        }
    }
}
