package com.elitescloud.boot.jpa.support.id.provider.snowflake.assigner;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.jpa.support.id.provider.snowflake.WorkerInfo;
import com.elitescloud.cloudt.context.util.SystemUtil;
import lombok.extern.log4j.Log4j2;

import java.util.concurrent.atomic.AtomicBoolean;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/7
 */
@Log4j2
abstract class AbstractSnowflakeWorkerAssigner implements SnowflakeWorkerAssigner {
    private static final AtomicBoolean INITIALIZING = new AtomicBoolean(false);
    private static volatile WorkerInfo workerInfo;

    /**
     * 创建worker
     *
     * @return worker信息
     */
    protected abstract WorkerInfo distribute();

    @Override
    public WorkerInfo assign() {
        if (workerInfo != null) {
            return workerInfo;
        }

        if (INITIALIZING.compareAndSet(false, true)) {
            // 未初始化
            synchronized (AbstractSnowflakeWorkerAssigner.class) {
                workerInfo = distribute();
            }
            log.info("Id生成器Worker信息：{}-{}", workerInfo.getDataCenterId(), workerInfo.getWorkerId());
            return workerInfo;
        }

        synchronized (AbstractSnowflakeWorkerAssigner.class) {
            return workerInfo;
        }
    }

    protected String getIp() {
        var address = SystemUtil.getCurrentAddress();
        return ObjectUtil.defaultIfNull(address.getHostAddress(), "127.0.0.1");
    }
}
