/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.config;

import cn.hutool.core.util.ReflectUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import org.hibernate.annotations.Comment;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataContributor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.jboss.jandex.IndexView;
import org.springframework.util.StringUtils;

public class CloudtMetadataContributor
implements MetadataContributor {
    public void contribute(InFlightMetadataCollector metadataCollector, IndexView jandexIndex) {
        for (PersistentClass entityBinding : metadataCollector.getEntityBindings()) {
            this.processComment(entityBinding);
        }
    }

    private void processComment(PersistentClass persistentClass) {
        Table table = persistentClass.getTable();
        Class entityClass = persistentClass.getMappedClass();
        if (!StringUtils.hasText((String)table.getComment())) {
            table.setComment(this.obtainTableComment(persistentClass, entityClass));
        }
        this.fillColumn(table, entityClass);
    }

    private void fillColumn(Table table, Class<?> entityClass) {
        Field[] fields;
        Iterator columnIterable = table.getColumnIterator();
        HashMap<String, Column> columnMap = new HashMap<String, Column>(64);
        Column column = null;
        while (columnIterable.hasNext()) {
            column = (Column)columnIterable.next();
            columnMap.put(column.getName().toLowerCase().replace("_", ""), column);
        }
        if (columnMap.isEmpty()) {
            return;
        }
        for (Field field : fields = ReflectUtil.getFields(entityClass)) {
            column = (Column)columnMap.get(field.getName().toLowerCase().replace("_", ""));
            if (column == null) continue;
            String fieldComment = this.obtainFieldComment(field);
            column.setComment(fieldComment);
            column.setDefaultValue(this.obtainDefaultValue(field));
        }
    }

    private String obtainDefaultValue(Field field) {
        com.elitescloud.cloudt.common.annotation.Comment comment = field.getAnnotation(com.elitescloud.cloudt.common.annotation.Comment.class);
        if (comment != null && StringUtils.hasText((String)comment.defaultValue())) {
            return comment.defaultValue();
        }
        return null;
    }

    private String obtainFieldComment(Field field) {
        com.elitescloud.cloudt.common.annotation.Comment comment = field.getAnnotation(com.elitescloud.cloudt.common.annotation.Comment.class);
        if (comment != null && StringUtils.hasText((String)comment.value())) {
            return comment.value();
        }
        Comment commentHibernate = field.getAnnotation(Comment.class);
        if (commentHibernate != null && StringUtils.hasText((String)commentHibernate.value())) {
            return commentHibernate.value();
        }
        ApiModelProperty apiModelProperty = field.getAnnotation(ApiModelProperty.class);
        if (apiModelProperty != null && StringUtils.hasText((String)apiModelProperty.value())) {
            return apiModelProperty.value();
        }
        return null;
    }

    private String obtainTableComment(PersistentClass persistentClass, Class<?> entityClass) {
        com.elitescloud.cloudt.common.annotation.Comment comment = entityClass.getAnnotation(com.elitescloud.cloudt.common.annotation.Comment.class);
        if (comment != null && StringUtils.hasText((String)comment.value())) {
            return comment.value();
        }
        ApiModel apiModel = entityClass.getAnnotation(ApiModel.class);
        if (apiModel != null) {
            String value = apiModel.value();
            if (!StringUtils.hasText((String)value)) {
                value = apiModel.description();
            }
            if (StringUtils.hasText((String)value)) {
                return value;
            }
        }
        return null;
    }
}

