/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.config.entity;

import com.elitescloud.boot.jpa.common.EntityFilterHandler;
import javax.persistence.EntityManagerFactory;
import org.hibernate.internal.SessionImpl;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;

public class EntityFilterProvider
implements InitializingBean {
    private final FactoryBean<EntityManagerFactory> entityManagerFactoryFactoryBean;
    private final EntityFilterHandler handler;

    public EntityFilterProvider(FactoryBean<EntityManagerFactory> entityManagerFactoryFactoryBean, EntityFilterHandler handler) {
        this.entityManagerFactoryFactoryBean = entityManagerFactoryFactoryBean;
        this.handler = handler;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.handler == null) {
            return;
        }
        if (this.entityManagerFactoryFactoryBean instanceof AbstractEntityManagerFactoryBean) {
            ((AbstractEntityManagerFactoryBean)this.entityManagerFactoryFactoryBean).setEntityManagerInitializer(entityManager -> {
                if (entityManager instanceof SessionImpl) {
                    SessionImpl session = (SessionImpl)entityManager;
                    this.handler.enableFilter(session);
                }
            });
        }
    }
}

