/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.support.id.provider.snowflake.config;

import com.elitescloud.boot.jpa.support.id.config.IdProperties;
import com.elitescloud.boot.jpa.support.id.provider.snowflake.SnowflakeProvider;
import com.elitescloud.boot.jpa.support.id.provider.snowflake.assigner.DatabaseSnowflakeWorkerAssigner;
import com.elitescloud.boot.jpa.support.id.provider.snowflake.assigner.ManualSnowflakeWorkerAssigner;
import com.elitescloud.boot.jpa.support.id.provider.snowflake.assigner.RedisSnowflakeWorkerAssigner;
import com.elitescloud.boot.jpa.support.id.provider.snowflake.assigner.SnowflakeWorkerAssigner;
import com.elitescloud.boot.jpa.support.id.util.IdTool;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.JdbcProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.lang.NonNull;

@ConditionalOnProperty(prefix="elitesland.id", name={"gen-type"}, havingValue="SNOWFLAKE", matchIfMissing=true)
public class SnowflakeConfig
implements EnvironmentAware {
    @Value(value="${spring.application.name:#{'unknown'}}")
    private String dataCenterName;
    private final IdProperties idProperties;
    private final DataSource dataSource;
    private Environment environment;

    public SnowflakeConfig(IdProperties idProperties, DataSource dataSource) {
        this.idProperties = idProperties;
        this.dataSource = dataSource;
    }

    public void setEnvironment(@NonNull Environment environment) {
        this.environment = environment;
    }

    @Bean
    public SnowflakeProvider snowflakeProvider(SnowflakeWorkerAssigner workerAssigner) {
        return new SnowflakeProvider(workerAssigner);
    }

    @Bean
    @ConditionalOnProperty(prefix="elitesland.id", name={"assigner-type"}, havingValue="MANUAL", matchIfMissing=true)
    public SnowflakeWorkerAssigner idGeneratorBuildableManual() {
        return new ManualSnowflakeWorkerAssigner(this.idProperties);
    }

    @Bean
    @ConditionalOnProperty(prefix="elitesland.id", name={"assigner-type"}, havingValue="DATABASE")
    public SnowflakeWorkerAssigner idGeneratorBuildableDatabase(JdbcProperties properties) {
        JdbcTemplate jdbcTemplate = IdTool.buildJdbcTemplate(this.environment, this.dataSource, this.idProperties, properties);
        return new DatabaseSnowflakeWorkerAssigner(this.dataCenterName, this.idProperties, jdbcTemplate);
    }

    @Configuration
    @ConditionalOnBean(value={RedisTemplate.class})
    static class RedisSupportConfig {
        @Value(value="${spring.application.name:#{'unknown'}}")
        private String dataCenterName;
        private final IdProperties idProperties;

        public RedisSupportConfig(IdProperties idProperties) {
            this.idProperties = idProperties;
        }

        @Bean
        @ConditionalOnProperty(prefix="elitesland.id", name={"assigner-type"}, havingValue="REDIS")
        public SnowflakeWorkerAssigner idGeneratorBuildableRedis(RedisTemplate redisTemplate) {
            return new RedisSnowflakeWorkerAssigner(this.dataCenterName, this.idProperties, redisTemplate);
        }
    }
}

