/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.config.auditing;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.context.TenantOrgContext;
import com.elitescloud.boot.jpa.config.auditing.AuditCustomizer;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.UserDetailProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;

public class CustomAuditHandler
extends AuditingHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomAuditHandler.class);
    private TenantClientProvider tenantClientProvider;
    private UserDetailProvider userProvider;
    private List<AuditCustomizer> customizers;

    public CustomAuditHandler(MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext) {
        super(mappingContext);
    }

    public CustomAuditHandler(PersistentEntities entities) {
        super(entities);
    }

    @Nonnull
    public <T> T markCreated(@Nonnull T source) {
        if (source instanceof BaseModel) {
            BaseModel entity = (BaseModel)source;
            LocalDateTime now = entity.getCreateTime() == null ? LocalDateTime.now() : entity.getCreateTime();
            Long tenantId = entity.getTenantId() == null ? this.obtainTenantId() : entity.getTenantId();
            Long tenantOrgId = entity.getTenantOrgId() == null ? this.obtainTenantOrgId() : entity.getTenantOrgId();
            Long orgId = (Long)ObjectUtil.defaultIfNull((Object)entity.getBelongOrgId(), (Object)entity.getSecBuId());
            GeneralUserDetails user = this.currentUser();
            Long currentUserId = 0L;
            String currentUsername = null;
            if (user != null && user.getUser() != null) {
                currentUserId = user.getUserId();
                currentUsername = user.getUser().getPrettyName();
                Long l = orgId = orgId == null ? user.getOrgId() : orgId;
            }
            if (entity.getCreateUserId() != null && CharSequenceUtil.isNotBlank((CharSequence)entity.getCreator())) {
                currentUserId = entity.getCreateUserId();
                currentUsername = entity.getCreator();
            }
            entity.setCreateUserId(currentUserId);
            entity.setCreator(currentUsername);
            entity.setCreateTime(now);
            if (entity.getModifyUserId() == null || CharSequenceUtil.isBlank((CharSequence)entity.getUpdater())) {
                entity.setModifyUserId(currentUserId);
                entity.setUpdater(currentUsername);
            }
            entity.setModifyTime((LocalDateTime)ObjectUtil.defaultIfNull((Object)entity.getModifyTime(), (Object)now));
            entity.setDeleteFlag((Integer)ObjectUtil.defaultIfNull((Object)entity.getDeleteFlag(), (Object)0));
            entity.setTenantId(tenantId);
            entity.setTenantOrgId(tenantOrgId);
            entity.setBelongOrgId(orgId);
        }
        this.getCustomizers().forEach(t -> t.onCreate(source));
        return source;
    }

    @Nonnull
    public <T> T markModified(@Nonnull T source) {
        if (source instanceof BaseModel) {
            BaseModel entity = (BaseModel)source;
            GeneralUserDetails user = this.currentUser();
            if (user != null && user.getUser() != null) {
                entity.setModifyUserId(user.getUserId());
                entity.setUpdater(user.getUser().getPrettyName());
            }
            entity.setModifyTime(LocalDateTime.now());
            if (entity.getDeleteFlag() == null) {
                entity.setDeleteFlag(Integer.valueOf(0));
            }
        }
        this.getCustomizers().forEach(t -> t.onUpdate(source));
        return source;
    }

    private Long obtainTenantId() {
        SysTenantDTO currentTenant = this.getTenantClientProvider().getSessionTenant();
        if (currentTenant != null) {
            return currentTenant.getId();
        }
        return TenantConstant.DEFAULT_TENANT_ID;
    }

    private Long obtainTenantOrgId() {
        Boolean useTenantOrg = TenantOrgContext.isUseTenantOrg();
        if (!((Boolean)ObjectUtil.defaultIfNull((Object)useTenantOrg, (Object)true)).booleanValue()) {
            return null;
        }
        return TenantOrgContext.getTenantOrg();
    }

    private GeneralUserDetails currentUser() {
        if (this.userProvider == null) {
            this.userProvider = (UserDetailProvider)SpringContextHolder.getBean(UserDetailProvider.class);
        }
        return this.userProvider.currentUser();
    }

    public TenantClientProvider getTenantClientProvider() {
        if (this.tenantClientProvider == null) {
            this.tenantClientProvider = (TenantClientProvider)SpringContextHolder.getBean(TenantClientProvider.class);
        }
        return this.tenantClientProvider;
    }

    public List<AuditCustomizer> getCustomizers() {
        if (this.customizers == null) {
            this.customizers = SpringContextHolder.getObjectProvider(AuditCustomizer.class).stream().collect(Collectors.toList());
        }
        return this.customizers;
    }
}

