package com.elitescloud.boot.mq.compensate.config;

import com.elitescloud.boot.mq.compensate.controller.SysRocketMqConsumeFailLogController;
import com.elitescloud.boot.mq.compensate.controller.SysRocketMqConsumeLogController;
import com.elitescloud.boot.mq.compensate.output.CloudTMqSink;
import com.elitescloud.boot.mq.compensate.output.CloudTMqSource;
import com.elitescloud.boot.mq.compensate.repo.SysRocketMqConsumeFailLogRepo;
import com.elitescloud.boot.mq.compensate.repo.SysRocketMqConsumeFailLogRepoProc;
import com.elitescloud.boot.mq.compensate.repo.SysRocketMqConsumeLogRepo;
import com.elitescloud.boot.mq.compensate.repo.SysRocketMqConsumeLogRepoProc;
import com.elitescloud.boot.mq.compensate.service.SysRocketMqConsumeFailLogService;
import com.elitescloud.boot.mq.compensate.service.SysRocketMqConsumeLogService;
import com.elitescloud.boot.mq.compensate.service.impl.SysRocketMqConsumeFailLogServiceImpl;
import com.elitescloud.boot.mq.compensate.service.impl.SysRocketMqConsumeLogServiceImpl;
import com.elitescloud.boot.mq.compensate.utils.MQConsumeUtils;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.config.BindingServiceConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman
 * @since 2022/4/6 9:27 AM
 */
@ConditionalOnClass({BindingServiceConfiguration.class, CompensateSwaggerConfig.class})
@ConditionalOnProperty(prefix = "spring.cloud.stream.bindings.cloudt-input", value = "destination")
@EnableBinding({CloudTMqSource.class, CloudTMqSink.class})
@Import({CompensateSwaggerConfig.class})
public class CloudStreamConfig {

    @Bean
    public SysRocketMqConsumeFailLogRepoProc sysRocketMqConsumeFailLogRepoProc(JPAQueryFactory jpaQueryFactory) {
        return new SysRocketMqConsumeFailLogRepoProc(jpaQueryFactory);
    }

    @Bean
    public SysRocketMqConsumeLogRepoProc sysRocketMqConsumeLogRepoProc(JPAQueryFactory jpaQueryFactory) {
        return new SysRocketMqConsumeLogRepoProc(jpaQueryFactory);
    }

    @Bean
    public SysRocketMqConsumeFailLogService sysRocketMqConsumeFailLogService(SysRocketMqConsumeFailLogRepo sysRocketMqConsumeFailLogRepo,
                                                                             SysRocketMqConsumeFailLogRepoProc sysRocketMqConsumeFailLogRepoProc,
                                                                             RocketMQTemplate rocketMQTemplate) {
        return new SysRocketMqConsumeFailLogServiceImpl(sysRocketMqConsumeFailLogRepo, sysRocketMqConsumeFailLogRepoProc, rocketMQTemplate);
    }

    @Bean
    public SysRocketMqConsumeLogService sysRocketMqConsumeLogService(SysRocketMqConsumeLogRepo sysRocketMqConsumeLogRepo,
                                                                     SysRocketMqConsumeLogRepoProc sysRocketMqConsumeLogRepoProc) {
        return new SysRocketMqConsumeLogServiceImpl(sysRocketMqConsumeLogRepo, sysRocketMqConsumeLogRepoProc);
    }

    @Bean
    public SysRocketMqConsumeFailLogController sysRocketMqConsumeFailLogController(SysRocketMqConsumeFailLogService sysRocketMqConsumeFailLogService) {
        return new SysRocketMqConsumeFailLogController(sysRocketMqConsumeFailLogService);
    }

    @Bean
    public SysRocketMqConsumeLogController sysRocketMqConsumeLogController(SysRocketMqConsumeLogService sysRocketMqConsumeLogService) {
        return new SysRocketMqConsumeLogController(sysRocketMqConsumeLogService);
    }

    @Bean
    public MQConsumeUtils mqConsumeUtils(SysRocketMqConsumeLogService sysRocketMqConsumeLogService) {
        return new MQConsumeUtils(sysRocketMqConsumeLogService);
    }
}
