package com.elitescloud.boot.mq.compensate.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman
 * @since 2022/4/1 3:09 PM
 */
@Entity
@Table(name = "sys_rocket_mq_consume_fail_log",uniqueConstraints = @UniqueConstraint(columnNames= {"consumerKey"}))
@org.hibernate.annotations.Table(appliesTo = "sys_rocket_mq_consume_fail_log", comment = "架构补偿机制-消费失败记录")
@Data
@Accessors(chain = true)
@ApiModel(value = "架构补偿机制-消费失败记录", description = "架构补偿机制-消费失败记录")
@DynamicUpdate
public class SysRocketMqConsumeFailLogDO extends BaseModel implements Serializable {

    @ApiModelProperty(value = "消费失败类型；1：消费次数过多，2：业务异常，3：长时间无法消费")
    @Comment("消费失败类型：1：消费次数过多，2：业务异常，3：长时间无法消费,4:其他")
    @Column()
    private Integer typeId;

    @ApiModelProperty(value = "消费失败是否已处理；PROCESSED：已处理，TO_BE_PROCESSED:待处理")
    @Comment("消费失败是否已处理；PROCESSED：已处理，TO_BE_PROCESSED:待处理")
    @Column()
    private String alreadyDeal;

    @ApiModelProperty(value = "消息体key")
    @Comment("消息体key")
    @Column()
    private String consumerKey;

    @ApiModelProperty(value = "消息体")
    @Comment("消息体")
    @Column()
    @Lob
    private byte[] consumerBoby;

    @ApiModelProperty(value = "消费者组")
    @Comment("消费者组")
    @Column()
    private String consumerGroup;

    @ApiModelProperty(value = "消费主题")
    @Comment("消费主题")
    @Column()
    private String consumerTopic;

    @ApiModelProperty("消费二级主题")
    @Column()
    private String consumerTag;

    @ApiModelProperty(value = "消息UUID")
    @Comment("消息UUID")
    private String messageUuid;

}
