package com.elitescloud.boot.mq.compensate.model.entity;

import com.elitescloud.boot.common.convert.BooleanToIntegerConverter;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * <p>
 * 功能说明:
 *   消费端：
 *     基于Rocket进行补偿机制。
 *     方案：
 *       对每条消费的消息数据，进入入库操作，在消费失败是，修改其状态。
 *     是否可以利用MQ自身的机制进行补偿
 *      1、自动重试机制
 *      2、自定义错误处理逻辑
 *      3、死信队列
 *      4、重新入队
 *
 * </p>
 *
 * @author roman
 * @since 2022/4/1 2:53 PM
 */
@Entity
@Table(name = "sys_rocket_mq_consume_log")
@org.hibernate.annotations.Table(appliesTo = "sys_rocket_mq_consume_log", comment = "架构补偿机制-消费记录")
@Data
@Accessors(chain = true)
@ApiModel(value = "架构补偿机制-消费记录", description = "架构补偿机制-消费记录")
@DynamicUpdate
public class SysRocketMqConsumeLogDO extends BaseModel implements Serializable {

    @ApiModelProperty(value = "消息行号")
    @JsonSerialize(using = ToStringSerializer.class)
    @Comment("消息行号")
    private Long lineNum;

    @ApiModelProperty(value = "消息体key")
    @Comment("消息体key")
    private Integer queueId;

    @ApiModelProperty(value = "消息标识")
    @Comment("消息标识")
    private String messageId;

    @ApiModelProperty(value = "消息UUID")
    @Comment("消息UUID")
    private String messageUuid;

    @ApiModelProperty(value = "重复消费的次数")
    @Comment("消息标识")
    private Integer reconsumeTimes;

    @ApiModelProperty(value = "消息体key")
    @Comment("消息体key")
    @Column()
    private String consumerKey;

    @ApiModelProperty(value = "消费者组")
    @Comment("消费者组")
    @Column()
    private String consumerGroup;

    @ApiModelProperty(value = "消费主题")
    @Comment("消费主题")
    @Column()
    private String consumerTopic;

    @ApiModelProperty(value = "是否消费成功:true:成功，false:失败")
    @Comment("是否消费成功:true:成功，false:失败")
    @Column()
    @Convert(converter = BooleanToIntegerConverter.class)
    private Boolean isSuccess;

    @ApiModelProperty(value = "失败详情")
    @Comment("失败详情")
    @Column()
    private String failDetail;
}
