package com.elitescloud.boot.mq.compensate.param;


import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "SysRocketMqConsumeFailLogQueryParam", description = "架构补偿机制-消费失败记录")
public class SysRocketMqConsumeFailLogQueryParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -79464212496324836L;
    /**
    * 记录唯一ID
    */    
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
    * 消费失败类型：1：消费次数过多，2：业务异常，3：长时间无法消费,4:其他
    */    
    @ApiModelProperty("消费失败类型：1：消费次数过多，2：业务异常，3：长时间无法消费,4:其他")
    private Integer typeId;
    /**
    * 消费失败是否已处理；PROCESSED：已处理，TO_BE_PROCESSED:待处理
    */    
    @ApiModelProperty("消费失败是否已处理；PROCESSED：已处理，TO_BE_PROCESSED:待处理")
    private String alreadyDeal;
    /**
    * 消息体key
    */    
    @ApiModelProperty("消息体key")
    private String consumerKey;

    @ApiModelProperty(value = "消息体")
    private byte[] consumerBoby;

    @ApiModelProperty(value = "消息UUID")
    @Comment("消息UUID")
    private String messageUuid;

    /**
    * 消费者组
    */    
    @ApiModelProperty("消费者组")
    private String consumerGroup;
    /**
    * 消费主题
    */    
    @ApiModelProperty("消费主题")
    private String consumerTopic;
    /*
     * 消费主题
    */
    @ApiModelProperty("自定义消费主题")
    private String customConsumerTopic;

    @ApiModelProperty("消费二级主题")
    private String consumerTag;
    /**
    * 消费数据详情
    */    
    @ApiModelProperty("消费数据详情")
    private String messageDetail;
    /**
    * 租户ID
    */    
    @ApiModelProperty("租户ID")
    private Long tenantId;
    /**
    * 备注
    */    
    @ApiModelProperty("备注")
    private String remark;
    /**
    * 记录创建者ID
    */    
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    /**
    * 记录创建者
    */    
    @ApiModelProperty("记录创建者")
    private String creator;
    /**
    * 记录创建时间
    */    
    @ApiModelProperty("记录创建时间")
    private String createTime;
    /**
    * 记录最后更新者ID
    */    
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;
    /**
    * 记录最后更新者
    */    
    @ApiModelProperty("记录最后更新者")
    private String updater;
    /**
    * 记录最后更新时间
    */    
    @ApiModelProperty("记录最后更新时间")
    private String modifyTime;
    /**
    * 逻辑删除，0：未删除，1：已删除
    */    
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
    * 锁版本
    */    
    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;
    /**
    * sec_bu_id
    */    
    @ApiModelProperty("sec_bu_id")
    private Long secBuId;
    /**
    * sec_user_id
    */    
    @ApiModelProperty("sec_user_id")
    private Long secUserId;
    /**
    * sec_ou_id
    */    
    @ApiModelProperty("sec_ou_id")
    private Long secOuId;


}
