package com.elitescloud.boot.mq.compensate.service;

import com.elitescloud.boot.mq.compensate.model.vo.SysRocketMqConsumeLogVO;
import com.elitescloud.boot.mq.compensate.param.SysRocketMqConsumeLogCreateParam;
import com.elitescloud.boot.mq.compensate.param.SysRocketMqConsumeLogQueryParam;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;
import java.util.Optional;
/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman.zhang
 * @since 2022-04-01 16:06:24
 */
public interface SysRocketMqConsumeLogService {
 /**
     * 检索 
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<SysRocketMqConsumeLogVO> search(SysRocketMqConsumeLogQueryParam queryParam);

    /**
     * 根据关键字段，返回对应的vo
     * @param Code  code
     * @return  对象
     */
    Optional<SysRocketMqConsumeLogVO> findCodeOne(String Code);
    /**
     * 根据关键字段，返回对应的
     * @param Id ID
     * @return 对象
     */
    Optional<SysRocketMqConsumeLogVO> findIdOne(Long Id);
    /**
     * 根据关键字段，返回对应的
     * @param idList ID集合
     * @return 对象
     */
   List<SysRocketMqConsumeLogVO>  findIdBatch(List<Long> idList);
    /**
     * 创建
     *
     * @param  creatParam 对象
     */
    Long createOne(SysRocketMqConsumeLogCreateParam creatParam);
    /**
     * 创建
     *
     * @param List 对象集合
     */
    List<Long> createBatch(List<SysRocketMqConsumeLogCreateParam> List);
//    /**
//     * 更新
//     *
//     * @param  updateParam 对象
//     */
//    void update(SysRocketMqConsumeLogUpdateParam updateParam) ;

    /**
     * 删除
     *
     * @param Id 对象
     */
    void deleteOne(Long Id);
    /**
     * 删除
     *
     * @param idList 对象集合
     */
    void deleteBatch(List<Long> idList);

    /**
     * 更新删除标识
     *
     * @param id id
     */
    void updateDeleteFlag(Long id);
}


