package com.elitescloud.boot.mq.compensate.service.impl;

import com.elitescloud.boot.mq.compensate.convert.SysRocketMqConsumeLogConvert;
import com.elitescloud.boot.mq.compensate.model.entity.QSysRocketMqConsumeLogDO;
import com.elitescloud.boot.mq.compensate.model.entity.SysRocketMqConsumeLogDO;
import com.elitescloud.boot.mq.compensate.model.vo.SysRocketMqConsumeLogVO;
import com.elitescloud.boot.mq.compensate.param.SysRocketMqConsumeLogCreateParam;
import com.elitescloud.boot.mq.compensate.param.SysRocketMqConsumeLogQueryParam;
import com.elitescloud.boot.mq.compensate.repo.SysRocketMqConsumeLogRepo;
import com.elitescloud.boot.mq.compensate.repo.SysRocketMqConsumeLogRepoProc;
import com.elitescloud.boot.mq.compensate.service.SysRocketMqConsumeLogService;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman.zhang
 * @since 2022-04-01 16:06:24
 */
public class SysRocketMqConsumeLogServiceImpl implements SysRocketMqConsumeLogService {

    private final SysRocketMqConsumeLogRepo sysRocketMqConsumeLogRepo;
    private final SysRocketMqConsumeLogRepoProc sysRocketMqConsumeLogRepoProc;

    public SysRocketMqConsumeLogServiceImpl(SysRocketMqConsumeLogRepo sysRocketMqConsumeLogRepo, SysRocketMqConsumeLogRepoProc sysRocketMqConsumeLogRepoProc) {
        this.sysRocketMqConsumeLogRepo = sysRocketMqConsumeLogRepo;
        this.sysRocketMqConsumeLogRepoProc = sysRocketMqConsumeLogRepoProc;
    }

    @Override
    @SysCodeProc
    public PagingVO<SysRocketMqConsumeLogVO> search(SysRocketMqConsumeLogQueryParam param){
        val ret = sysRocketMqConsumeLogRepo.findAll(sysRocketMqConsumeLogRepoProc.where(param), param.getPageRequest());
        val vos = ret.getContent().stream().map(SysRocketMqConsumeLogConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.<SysRocketMqConsumeLogVO>builder()
                .total(ret.getTotalElements())
                .records(vos)
                .build();
    }
 
    @Override
    @SysCodeProc
    public Optional<SysRocketMqConsumeLogVO> findCodeOne(String itemCode) {
        JPAQuery<SysRocketMqConsumeLogVO> jpaQuery = sysRocketMqConsumeLogRepoProc.select(null);
        val jpaQDo = QSysRocketMqConsumeLogDO.sysRocketMqConsumeLogDO;
        //设置查询条件
        //jpaQuery.where(jpaQDo.itemCode.eq(itemCode));
        SysRocketMqConsumeLogVO vo = jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }
    @Override
    @SysCodeProc
    public Optional<SysRocketMqConsumeLogVO> findIdOne(Long id) {
        return sysRocketMqConsumeLogRepo.findById(id).map(SysRocketMqConsumeLogConvert.INSTANCE::doToVO);
    }
    
    @Override
    @SysCodeProc
    public List<SysRocketMqConsumeLogVO> findIdBatch(List<Long> idList) {
         return sysRocketMqConsumeLogRepo.findAllById(idList).stream().map(
               SysRocketMqConsumeLogConvert.INSTANCE::doToVO
        ).collect(Collectors.toList());
    }

    
    
    @Override
    @Transactional
    public Long createOne(SysRocketMqConsumeLogCreateParam param){
       SysRocketMqConsumeLogDO sysRocketMqConsumeLogDO = SysRocketMqConsumeLogConvert.INSTANCE.creatParamToDo(param);
       return sysRocketMqConsumeLogRepo.save(sysRocketMqConsumeLogDO).getId();
    }
    
    @Override
    @Transactional
    public List<Long> createBatch(List<SysRocketMqConsumeLogCreateParam> list){
        List<SysRocketMqConsumeLogDO> dos = list.stream().map(SysRocketMqConsumeLogConvert.INSTANCE::creatParamToDo).collect(Collectors.toList());
       return sysRocketMqConsumeLogRepo.saveAll(dos).stream().map(SysRocketMqConsumeLogDO::getId).collect(Collectors.toList());
    }
    
//    @Override
//    @Transactional
//    public void update(SysRocketMqConsumeLogUpdateParam param) {
//      SysRocketMqConsumeLogDO objDo = SysRocketMqConsumeLogConvert.INSTANCE.updateParamToDo(param);
//        Optional<SysRocketMqConsumeLogDO> optional = sysRocketMqConsumeLogRepo.findById(objDo.getId());
//        if(optional.isPresent()){
//             BeanCopyUtil.beanCopyWithIngore(objDo, optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
//             sysRocketMqConsumeLogRepo.save(optional.get());
//        }else{
//            throw new BusinessException(ApiCode.FAIL,"修改失败，数据不存在"+objDo.getId());
//        }
//    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
        val jpaQDo = QSysRocketMqConsumeLogDO.sysRocketMqConsumeLogDO;
        Predicate predicate = jpaQDo.isNotNull();
        predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(id));
                Optional<SysRocketMqConsumeLogDO> optionalItem=sysRocketMqConsumeLogRepo.findOne(predicate);
        if(optionalItem.isPresent()) {
            SysRocketMqConsumeLogDO do1 = optionalItem.get();
            do1.setDeleteFlag(1);
            sysRocketMqConsumeLogRepo.save(do1);
        }else{
             throw new BusinessException(ApiCode.FAIL,"修改失败，数据不存在"+id);
        }
    }

    
    
    @Override
    @Transactional
    public void deleteOne(Long id) {
     
      this.sysRocketMqConsumeLogRepo.deleteById(id) ;
      
    }
    
    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id-> sysRocketMqConsumeLogRepo.deleteById(id));
    }
}


