package com.elitescloud.boot.mq.tenant;

import com.elitescloud.boot.condition.ConditionalOnTenant;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.stream.config.ChannelsEndpointAutoConfiguration;
import org.springframework.cloud.stream.messaging.DirectWithAttributesChannel;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;

/**
 * 租户的上下文传播.
 *
 * @author Kaiser（wang shao）
 * @date 2022/5/23
 */
@Log4j2
@ConditionalOnTenant
@ConditionalOnClass({ChannelsEndpointAutoConfiguration.class})
public class SpringCloudStreamTenantConfig {

    @Bean
    public BeanPostProcessor springCloudStreamChannelInterceptorTenant() {
        return new BeanPostProcessor() {
            @Override
            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return BeanPostProcessor.super.postProcessBeforeInitialization(bean, beanName);
            }

            @Override
            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof DirectWithAttributesChannel) {
                    DirectWithAttributesChannel channel = (DirectWithAttributesChannel) bean;
                    String type = (String) channel.getAttribute("type");
                    if (Sink.INPUT.equals(type)) {
                        channel.addInterceptor(0, new TenantMessagingInputInterceptor());
                    } else if (Source.OUTPUT.equals(type)) {
                        channel.addInterceptor(0, new TenantMessagingOutputInterceptor());
                    } else {
                        log.error("未知MessageChannel类型：{}，{}", beanName, type);
                    }
                }
                return BeanPostProcessor.super.postProcessAfterInitialization(bean, beanName);
            }
        };
    }
}
