package com.elitescloud.boot.openfeign;

import com.elitescloud.boot.condition.ConditionalOnTenant;
import com.elitescloud.boot.openfeign.interceptor.TenantContextInterceptor;
import com.elitescloud.boot.provider.TenantClientProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * OpenFeign集成租户.
 *
 * @author Kaiser（wang shao）
 * @date 3/24/2023
 */
@Configuration
@ConditionalOnTenant
class CloudtOpenFeignTenantAutoConfiguration {

    /**
     * 租户上下文传播
     *
     * @param clientProvider
     * @return
     */
    @Bean
    public TenantContextInterceptor tenantContextInterceptor(TenantClientProvider clientProvider) {
        return new TenantContextInterceptor(clientProvider);
    }
}
