package com.elitescloud.boot.openfeign;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.HashSet;
import java.util.Set;

/**
 * 属性配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/7/18
 */
@ConfigurationProperties(prefix = CloudtOpenFeignProperties.CONFIG_PREFIX)
public class CloudtOpenFeignProperties {
    public static final String CONFIG_PREFIX = "elitesland.openfeign";

    /**
     * 如果本地有实现bean，则直接使用本地的
     */
    public Boolean directLocal = true;

    /**
     * 支持本地的服务名称
     * <p>
     * {@link #directLocal} = true时有效，如果含有*，则表示所有服务
     */
    public Set<String> directLocalServices = new HashSet<>();

    public Boolean getDirectLocal() {
        return directLocal;
    }

    public void setDirectLocal(Boolean directLocal) {
        this.directLocal = directLocal;
    }

    public Set<String> getDirectLocalServices() {
        return directLocalServices;
    }

    public void setDirectLocalServices(Set<String> directLocalServices) {
        this.directLocalServices = directLocalServices;
    }
}
