/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.openfeign.config;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.openfeign.CloudtOpenFeignProperties;
import com.elitescloud.boot.openfeign.config.TargeterProxy;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.openfeign.Targeter;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

public class OpenFeignBeanPostProcessor
implements BeanPostProcessor {
    private final String applicationName;
    private final CloudtOpenFeignProperties properties;

    public OpenFeignBeanPostProcessor(String applicationName, CloudtOpenFeignProperties properties) {
        this.applicationName = applicationName;
        this.properties = properties;
    }

    public Object postProcessAfterInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        if (bean instanceof Targeter) {
            return new TargeterProxy((Targeter)bean, this.buildProxyServices(), this.properties);
        }
        return super.postProcessAfterInitialization(bean, beanName);
    }

    private Set<String> buildProxyServices() {
        HashSet<String> services = new HashSet<String>();
        if (CollUtil.isNotEmpty(this.properties.getDirectLocalServices())) {
            boolean proxyAll = this.properties.getDirectLocalServices().stream().anyMatch("*"::equals);
            if (proxyAll) {
                services.add("*");
                return services;
            }
            services.addAll(this.properties.getDirectLocalServices());
        }
        if (StringUtils.hasText((String)this.applicationName)) {
            services.add(this.applicationName);
        }
        return services;
    }
}

