/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.openfeign.config;

import com.elitescloud.boot.openfeign.config.CloudtBlockingLoadBalancerClient;
import com.elitescloud.boot.openfeign.config.CloudtHeaderInterceptor;
import com.elitescloud.boot.openfeign.config.CloudtOpenFeignProperties;
import com.elitescloud.boot.openfeign.config.FeignAuthenticationContextInterceptor;
import com.elitescloud.boot.openfeign.config.FeignTraceLogInterceptor;
import com.elitescloud.boot.openfeign.config.OpenFeignBeanPostProcessor;
import feign.Response;
import feign.codec.ErrorDecoder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.loadbalancer.config.BlockingLoadBalancerClientAutoConfiguration;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@EnableConfigurationProperties(value={CloudtOpenFeignProperties.class})
@EnableFeignClients(basePackages={"com.elitescloud", "com.elitesland"})
@AutoConfigureBefore(value={BlockingLoadBalancerClientAutoConfiguration.class})
class CloudtOpenFeignAutoConfiguration {
    private static final Logger log = LogManager.getLogger(CloudtOpenFeignAutoConfiguration.class);
    @Value(value="${spring.application.name:#{null}}")
    private String applicationName;
    @Value(value="${server.port:8080}")
    private Integer port;
    private final CloudtOpenFeignProperties properties;

    public CloudtOpenFeignAutoConfiguration(CloudtOpenFeignProperties properties) {
        this.properties = properties;
    }

    @Bean
    public LoadBalancerClient blockingLoadBalancerClient(LoadBalancerClientFactory loadBalancerClientFactory) {
        return new CloudtBlockingLoadBalancerClient(this.applicationName, this.port, (ReactiveLoadBalancer.Factory<ServiceInstance>)loadBalancerClientFactory);
    }

    @Bean
    public WebMvcRegistrations feignWebRegistrations() {
        return new WebMvcRegistrations(){

            public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
                return new RequestMappingHandlerMapping(){

                    protected boolean isHandler(@NonNull Class<?> beanType) {
                        return super.isHandler(beanType) && !beanType.isAnnotationPresent(FeignClient.class);
                    }
                };
            }
        };
    }

    @Bean
    @ConditionalOnClass(name={"com.elitescloud.cloudt.authorization.core.SecurityContextUtil"})
    public FeignAuthenticationContextInterceptor feignAuthenticationContextInterceptor() {
        return new FeignAuthenticationContextInterceptor();
    }

    @Bean
    public CloudtHeaderInterceptor cloudtHeaderInterceptor() {
        return new CloudtHeaderInterceptor();
    }

    @Bean
    public FeignTraceLogInterceptor feignLogTraceHandler() {
        return new FeignTraceLogInterceptor(this.applicationName);
    }

    @Bean
    public ErrorDecoder errorDecoder() {
        return new ErrorDecoder.Default(){

            public Exception decode(String methodKey, Response response) {
                Exception exp = super.decode(methodKey, response);
                log.error("OpenFeign\u5904\u7406\u5f02\u5e38\uff1a", (Throwable)exp);
                return exp;
            }
        };
    }

    @Bean
    @ConditionalOnProperty(prefix="elitesland.openfeign", name={"direct-local"}, havingValue="true", matchIfMissing=true)
    public BeanPostProcessor openFeignBeanPostProcessor() {
        return new OpenFeignBeanPostProcessor(this.applicationName, this.properties);
    }
}

