# ServiceProviderLoader使用说明

> SPI（Service Provider Interace）是JDK内置的一种服务提供发现机制，用来框架扩展。为方便使用SPI，特封装了些常用的公共方法，使用入口可直接查看类ServiceProviderLoader。

### SPI的基本使用

###### 定义接口

```
package com.elitesland.test

public interface AnimalService {

    void sayHello(String username);
}
```

###### 定义扩展实现

```
package com.wangs.animal

public class MonkeyServiceImpl implements AnimalService {

    @Override
    public void sayHello(String username) {
        System.out.println("Hi, " + username + ", this is Monkey !");
    }

}

public class PigServiceImpl implements AnimalService {

    @Override
    public void sayHello(String username) {
        System.out.println("Hi, " + username + ", this is Pig !");
    }
}
```

**<u><mark>特别提醒：提供者必须提供一个公共的无参构造方法！</mark></u>**

###### 配置SPI

在resources目录下新建META-INF/services目录，在该目录下新建文件，文件名为扩展的接口名称，如com.elitesland.test.AnimalService，文件中写上实现类的全量名称（如果有多个实现，则换行分隔）。

```
com.wangs.animal.PigServiceImpl
com.wangs.animal.MonkeyServiceImpl
```

### 公共方法

工具类是`spi.com.elitescloud.cloudt.context.ServiceProviderLoader`，其中loadProviderInstantces()方法是获取所有提供者，loadProviderInstanceOne()是获取一个提供者，如果有配置默认实现，则优先获取默认实现，如果没有则优先从项目中获取，最后从第三方lib包中获取。

### 扩展支持

- **排序**：默认情况先优先加载项目中的实现（即编译后在classes中的类），其次从其它依赖的jar包中获取（即lib中的jar包）。提供者的自定义排序支持的注解：`org.springframework.core.annotation.Order`、`javax.annotation.Priority`，也支持实现接口`org.springframework.core.Ordered`。

- **默认实现**：在接口上增加注解`com.elitesland.yst.common.annotation.context.spi.SPI`，通过其primary()指定默认实现的全量类名称，如果未找到则会报错，且该方式设置的有限级最高。还可以在提供者上增加注解`org.springframework.context.annotation.Primary`来指定默认实现。

- **自动装配依赖**：通过ServiceProviderLoader类获取的服务提供者支持依赖的自动装配（Spring容器中的bean依赖），支持注解和set方法的注入，支持`org.springframework.beans.factory.annotation.Autowired`、`org.springframework.beans.factory.annotation.Qualifier`、`javax.annotation.Resource`、`javax.inject.Inject`、`javax.inject.Qualifier`等相关注解。


