package com.elitescloud.boot.spi;

import com.elitescloud.boot.spi.registrar.SpiServiceRegistrar;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Import;

/**
 * SPI自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/11/10
 */
@EnableConfigurationProperties(CloudtSpiProperties.class)
@ConditionalOnProperty(prefix = CloudtSpiProperties.CONFIG_PREFIX, name = "enabled", havingValue = "true")
@Import({SpiServiceRegistrar.class})
class CloudtSpiAutoConfiguration {

}
