package com.elitescloud.boot.spi.common;

import java.util.List;
import java.util.Set;

/**
 * 实例选择策略.
 *
 * @author Kaiser（wang shao）
 * @date 2022/11/11
 */
public interface InstanceStrategy {

    /**
     * 选择实例
     *
     * @param instances 所有实例
     * @return 选择的实例
     */
    <T> List<T> choose(List<InstanceWrapper<T>> instances);

    class InstanceWrapper<T> {

        /**
         * 实例
         */
        private final T instance;
        /**
         * 顺序
         */
        private final int order;
        /**
         * 来自配置文件的配置
         */
        private final boolean configFile;
        /**
         * 标签
         */
        private final Set<String> tags;

        public InstanceWrapper(T instance, boolean configFile, int order, Set<String> tags) {
            this.instance = instance;
            this.configFile = configFile;
            this.order = order;
            this.tags = tags;
        }

        public T getInstance() {
            return instance;
        }

        public int getOrder() {
            return order;
        }

        public boolean isConfigFile() {
            return configFile;
        }

        public Set<String> getTags() {
            return tags;
        }
    }
}
