/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.spi.strategy;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.spi.common.InstanceStrategy;
import com.elitescloud.cloudt.core.tenant.support.TenantClientProvider;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class TenantIndustrySpiInstanceStrategy
implements InstanceStrategy {
    private TenantClientProvider tenantClientProvider;

    @Override
    public <T> List<T> choose(List<InstanceStrategy.InstanceWrapper<T>> instances) {
        if (instances.isEmpty()) {
            return Collections.emptyList();
        }
        SysTenantDTO tenant = this.getTenantClientProvider().getSessionTenant();
        if (tenant == null || CharSequenceUtil.isBlank((CharSequence)tenant.getIndustry())) {
            return Collections.emptyList();
        }
        return instances.stream().filter(t -> t.getTags() != null && t.getTags().contains(tenant.getIndustry())).map(InstanceStrategy.InstanceWrapper::getInstance).collect(Collectors.toList());
    }

    public TenantClientProvider getTenantClientProvider() {
        if (this.tenantClientProvider == null) {
            this.tenantClientProvider = (TenantClientProvider)SpringContextHolder.getBean(TenantClientProvider.class);
        }
        return this.tenantClientProvider;
    }
}

