package com.elitescloud.boot.swagger.openapi.model;

import com.elitescloud.boot.common.annotation.BusinessObject;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-01-02 17:19
 */
@Slf4j
@Data
public class BusinessObjectInfo implements Serializable {

    /**业务对象启用**/
    private Boolean enabled;
    /**业务对象类型**/
    private String businessType;
    /**业务对象描述**/
    private String businessDescription;
    /**RequestMapping 根路径**/
    private String  basePath;
    private String domain;

    public static BusinessObjectInfo getBusinessObjectInfo(BusinessObject businessObject){
        BusinessObjectInfo businessObjectInfo = new BusinessObjectInfo();
        businessObjectInfo.setEnabled(businessObject.enabled());
        businessObjectInfo.setBusinessType(businessObject.businessType());
        businessObjectInfo.setBusinessDescription(businessObject.businessDescription());
        businessObjectInfo.setDomain(businessObject.businessObjectDomain());
        return businessObjectInfo;
    }
}
