package com.elitescloud.boot.tenant.client;

import com.elitescloud.boot.condition.ConditionalOnTenant;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.tenant.client.support.config.TenantOrgTransactionAspect;
import com.elitescloud.boot.tenant.client.support.config.TenantTransactionAspect;
import com.elitescloud.boot.tenant.client.support.config.TenantTransactionWrapper;
import com.elitescloud.boot.tenant.client.support.impl.DefaultTenantDataIsolateProvider;
import com.elitescloud.boot.tenant.client.support.impl.DefaultTenantOrgDataIsolateProvider;
import com.elitescloud.boot.tenant.client.support.impl.TenantIsolate;
import com.elitescloud.boot.wrapper.Isolatable;
import com.elitescloud.boot.wrapper.TransactionWrapper;
import com.elitescloud.cloudt.core.tenant.support.TenantDataIsolateProvider;
import com.elitescloud.cloudt.core.tenant.support.TenantOrgDataIsolateProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.transaction.PlatformTransactionManager;

/**
 * 租户事务相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/4/13
 */
@ConditionalOnTenant
class CloudtTenantTransactionAutoConfiguration {

    @Bean
    public TenantTransactionAspect tenantTransactionAspect(@Qualifier(TransactionWrapper.TENANT) TransactionWrapper transactionWrapper) {
        return new TenantTransactionAspect(transactionWrapper);
    }

    @Bean(TransactionWrapper.TENANT)
    @Primary
    public TransactionWrapper tenantTransactionWrapper(PlatformTransactionManager transactionManager) {
        return new TenantTransactionWrapper(transactionManager);
    }

    @Bean
    public Isolatable tenantIsolate() {
        return new TenantIsolate();
    }

    @Bean
    public TenantDataIsolateProvider tenantDataIsolateProvider(TransactionWrapper transactionWrapper,
                                                               TenantClientProvider tenantClientProvider) {
        return new DefaultTenantDataIsolateProvider(transactionWrapper, tenantClientProvider);
    }

    @Bean
    public TenantOrgDataIsolateProvider tenantOrgDataIsolateProvider(PlatformTransactionManager transactionManager) {
        return new DefaultTenantOrgDataIsolateProvider(transactionManager);
    }

    @Bean
    public TenantOrgTransactionAspect tenantOrgTransactionAspect(TenantOrgDataIsolateProvider isolateProvider) {
        return new TenantOrgTransactionAspect(isolateProvider);
    }
}
