package com.elitescloud.boot.tenant.client.support.impl;

import com.elitescloud.boot.tenant.client.TenantClientProperties;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import lombok.extern.log4j.Log4j2;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.task.TaskExecutor;

/**
 * 租户schema初始化.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/24
 */
@Log4j2
public class TenantSchemaInitializer implements CommandLineRunner {

    private final ClientSyncTenantProvider clientSyncTenantProvider;
    private final TaskExecutor taskExecutor;
    private final TenantClientProperties tenantClientProperties;

    public TenantSchemaInitializer(ClientSyncTenantProvider clientSyncTenantProvider, TaskExecutor taskExecutor, TenantClientProperties tenantClientProperties) {
        this.clientSyncTenantProvider = clientSyncTenantProvider;
        this.taskExecutor = taskExecutor;
        this.tenantClientProperties = tenantClientProperties;
    }

    @Override
    public void run(String... args) throws Exception {
        taskExecutor.execute(this::syncClientInfo);
    }

    private void syncClientInfo() {
        if (tenantClientProperties.getIsolateStrategy() == TenantIsolateStrategy.NONE) {
            // 未启用数据分离
            log.info("未启用租户数据分离");
            return;
        }
        if (tenantClientProperties.getIsolateStrategy() == TenantIsolateStrategy.FIELD) {
            // 基于字段隔离
            log.info("基于字段隔离，无需同步租户表结构");
            return;
        }

        log.info("开始同步客户端租户数据表结构...");
        clientSyncTenantProvider.sync();
        log.info("同步客户端租户数据表结构结束！");
    }
}
