/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.support.app.CloudtAppHolder;
import com.elitescloud.boot.threadpool.common.ContextTransfer;
import com.elitescloud.boot.web.config.CloudtExceptionProperties;
import com.elitescloud.boot.web.config.WebMvcConfig;
import com.elitescloud.boot.web.exception.GlobalExceptionHandler;
import com.elitescloud.cloudt.common.base.ApiResult;
import java.util.HashMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Configuration(proxyBeanMethods=false)
@Import(value={WebMvcConfig.class})
@EnableConfigurationProperties(value={CloudtExceptionProperties.class})
class CloudtWebAutoConfiguration
implements InitializingBean {
    private final CloudtExceptionProperties exceptionProperties;

    public CloudtWebAutoConfiguration(CloudtExceptionProperties exceptionProperties) {
        this.exceptionProperties = exceptionProperties;
    }

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.hasText((String)this.exceptionProperties.getGlobal().getDefaultMsgFormat())) {
            ApiResult.setErrorMsgConvert((errorCode, errorNo) -> {
                HashMap<String, String> params = new HashMap<String, String>(4);
                params.put("appName", CloudtAppHolder.getAppName());
                params.put("errorNo", (String)errorNo);
                return StrUtil.format((CharSequence)this.exceptionProperties.getGlobal().getDefaultMsgFormat(), params);
            });
        }
    }

    @Bean
    public GlobalExceptionHandler globalExceptionHandler() {
        return new GlobalExceptionHandler(this.exceptionProperties);
    }

    @Bean
    public ContextTransfer<RequestAttributes> contextTransferRequestAttributes() {
        return new ContextTransfer<RequestAttributes>(){

            public RequestAttributes getContext() {
                return RequestContextHolder.getRequestAttributes();
            }

            public void setContext(RequestAttributes context) {
                RequestContextHolder.setRequestAttributes((RequestAttributes)context, (boolean)true);
            }

            public void clearContext() {
                RequestContextHolder.resetRequestAttributes();
            }
        };
    }
}

