package com.elitescloud.boot.web;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.common.servlet.CloudtRequestAttributes;
import com.elitescloud.boot.support.CloudtInterceptor;
import com.elitescloud.boot.support.app.CloudtAppHolder;
import com.elitescloud.boot.threadpool.common.ContextTransfer;
import com.elitescloud.boot.web.config.CloudtExceptionProperties;
import com.elitescloud.boot.web.config.ServletRequestContextTransfer;
import com.elitescloud.boot.web.config.WebMvcConfig;
import com.elitescloud.boot.web.config.WebRepeatRequestConfig;
import com.elitescloud.boot.web.config.filter.WebRequestInterceptor;
import com.elitescloud.boot.web.exception.GlobalExceptionHandler;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * web自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 3/20/2023
 */
@Import({WebRepeatRequestConfig.class, WebMvcConfig.class})
@EnableConfigurationProperties({CloudtExceptionProperties.class})
class CloudtWebAutoConfiguration implements InitializingBean {

    private final CloudtExceptionProperties exceptionProperties;

    public CloudtWebAutoConfiguration(CloudtExceptionProperties exceptionProperties) {
        this.exceptionProperties = exceptionProperties;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        // 异常转换
        if (StringUtils.hasText(exceptionProperties.getGlobal().getDefaultMsgFormat())) {
            ApiResult.setErrorMsgConvert((errorCode, errorNo) -> {
                Map<String, String> params = new HashMap<>(4);
                params.put("appName", CloudtAppHolder.getAppName());
                params.put("errorNo", errorNo);
                return StrUtil.format(exceptionProperties.getGlobal().getDefaultMsgFormat(), params);
            });
        }
    }

    @Bean
    public CloudtInterceptor cloudtInterceptorWeb() {
        return new WebRequestInterceptor();
    }

    /**
     * 全局异常处理
     *
     * @return 异常处理器
     */
    @Bean
    public GlobalExceptionHandler globalExceptionHandler() {
        return new GlobalExceptionHandler(exceptionProperties);
    }

    /**
     * 请求信息的上下文传递
     *
     * @return 上下文传递器
     */
    @Bean
    public ContextTransfer<CloudtRequestAttributes> contextTransferRequestAttributes() {
        return new ServletRequestContextTransfer();
    }
}
