package com.elitescloud.boot.web.config.trace;

import cn.hutool.core.lang.UUID;
import com.elitescloud.boot.base.AbstractLogTraceHandler;
import com.elitescloud.boot.constant.CommonConstant;
import org.slf4j.MDC;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * servlet类型的web容器链路跟踪日志过滤处理.
 *
 * @author Kaiser（wang shao）
 * @date 2021/12/23
 */
public class ServletWebLogTraceHandler extends AbstractLogTraceHandler implements Filter {

    public ServletWebLogTraceHandler(String traceIdPrefix) {
        super(traceIdPrefix);
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest) servletRequest;

        String traceId = request.getHeader(CommonConstant.LOG_TRACE_ID);
        putTraceId(traceId);

        putRequestId(request);

        filterChain.doFilter(servletRequest, servletResponse);
    }

    private void putRequestId(HttpServletRequest request) {
        String requestId = request.getHeader(CommonConstant.LOG_REQUEST_ID);

        if (requestId == null) {
            requestId = UUID.randomUUID().toString();
        }
        MDC.put(CommonConstant.LOG_REQUEST_ID, requestId);
    }
}
