package com.elitescloud.boot.web.config.trace;

import com.elitescloud.cloudt.common.constant.CommonConstant;
import com.elitescloud.boot.base.AbstractLogTraceHandler;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

/**
 * 响应式web 链路跟踪日志处理.
 *
 * @author Kaiser（wang shao）
 * @date 2021/12/23
 */
@Order(Ordered.HIGHEST_PRECEDENCE)
public class ReactiveWebLogTraceHandler extends AbstractLogTraceHandler implements WebFilter {

    public ReactiveWebLogTraceHandler(String traceIdPrefix) {
        super(traceIdPrefix);
    }

    @Override
    public Mono<Void> filter(ServerWebExchange serverWebExchange, WebFilterChain webFilterChain) {
        String traceId = serverWebExchange.getRequest().getHeaders().getFirst(CommonConstant.LOG_TRACE_ID);

        putTraceId(traceId);

        return webFilterChain.filter(serverWebExchange);
    }
}
