package com.elitescloud.boot.web.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 异常相关配置属性.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/29
 */
@ConfigurationProperties(prefix = CloudtExceptionProperties.CONFIG_PREFIX)
public class CloudtExceptionProperties {
    public static final String CONFIG_PREFIX = "elitesland.exception";

    private final GlobalExceptionConfig global = new GlobalExceptionConfig();

    public GlobalExceptionConfig getGlobal() {
        return global;
    }

    public static class GlobalExceptionConfig {
        /**
         * 消息格式，{appName}标识系统名称，{errorNo}标识错误号
         */
        private String defaultMsgFormat = "{appName}出现异常, 错误号：{errorNo}";

        /**
         * 是否将异常详细信息返回至data中
         */
        private Boolean exceptionDetailToData = true;

        public String getDefaultMsgFormat() {
            return defaultMsgFormat;
        }

        public void setDefaultMsgFormat(String defaultMsgFormat) {
            this.defaultMsgFormat = defaultMsgFormat;
        }

        public Boolean getExceptionDetailToData() {
            return exceptionDetailToData;
        }

        public void setExceptionDetailToData(Boolean exceptionDetailToData) {
            this.exceptionDetailToData = exceptionDetailToData;
        }
    }
}
