package com.elitescloud.boot.web.config;

import com.elitescloud.boot.web.config.trace.ReactiveWebLogTraceHandler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

/**
 * 响应式web的自定义配置.
 *
 * @author Kaiser（wang shao）
 * @date 2021/12/23
 */
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.REACTIVE)
public class CustomReactiveWebConfig extends AbstractCustomWebConfig {

    @Bean
    @Order(Ordered.HIGHEST_PRECEDENCE)
    public ReactiveWebLogTraceHandler reactiveWebLogTraceHandler() {
        return new ReactiveWebLogTraceHandler(applicationName);
    }
}
