package com.elitescloud.boot.web.config;

import com.elitescloud.boot.support.CloudtInterceptor;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Import;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.Comparator;

/**
 * mvc配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/4/27
 */
@Import({CustomReactiveWebConfig.class, CustomServletWebConfig.class})
@EnableConfigurationProperties({WebProperties.class})
@Log4j2
public class WebMvcConfig implements WebMvcConfigurer {

    @Autowired
    private ObjectProvider<CloudtInterceptor> interceptors;
    @Autowired
    private ThreadPoolTaskExecutor taskExecutor;

    @Override
    public void addInterceptors(@NonNull InterceptorRegistry registry) {
        interceptors.stream()
                .sorted(Comparator.comparingInt(CloudtInterceptor::order))
                .forEach(interceptor -> {
                    log.info("add interceptor：{}", interceptor.getClass().getName());
                    registry.addInterceptor(interceptor).addPathPatterns(interceptor.pathPatterns());
                });
    }

    @Override
    public void configureAsyncSupport(@NonNull AsyncSupportConfigurer configurer) {
        WebMvcConfigurer.super.configureAsyncSupport(configurer);

        configurer.setTaskExecutor(taskExecutor);
    }
}
