package com.elitescloud.boot.web.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * web相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/21
 */
@ConfigurationProperties(prefix = WebProperties.CONFIG_PREFIX)
public class WebProperties {
    public static final String CONFIG_PREFIX = "elitesland.web";

    /**
     * 包装request
     */
    private final WrapRequest wrapRequest = new WrapRequest();


    public WrapRequest getWrapRequest() {
        return wrapRequest;
    }

    public static class WrapRequest {
        /**
         * 是否启用包装request
         */
        private boolean enabled = true;

        /**
         * 是否支持对文件上传类请求的包装
         */
        private boolean supportMultipart = false;

        public boolean isEnabled() {
            return enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean getSupportMultipart() {
            return supportMultipart;
        }

        public void setSupportMultipart(boolean supportMultipart) {
            this.supportMultipart = supportMultipart;
        }
    }
}
