/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.exception;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.exception.CustomExceptionTranslate;
import com.elitescloud.boot.web.config.CloudtExceptionProperties;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.ResourceAccessException;

@ControllerAdvice
@ConditionalOnBean(value={CloudtExceptionProperties.class})
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private final CloudtExceptionProperties exceptionProperties;
    private List<CustomExceptionTranslate> exceptionTranslates;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");

    public GlobalExceptionHandler(CloudtExceptionProperties exceptionProperties) {
        this.exceptionProperties = exceptionProperties;
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    public ApiResult<String> handleHttpMessageNotReadableException(HttpServletRequest request, HttpServletResponse response, HttpMessageNotReadableException e) {
        String errorNo = this.printError(request, response, (Throwable)e, "\u8bf7\u6c42\u6570\u636e\u683c\u5f0f\u6709\u8bef");
        return ApiResult.fail((ApiCode)ApiCode.PARAMETER_PARSE_EXCEPTION, (String)errorNo, (String)this.stackTrace((Throwable)e), null, null);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public ApiResult<String> handleHttpRequestMethodNotSupportedException(HttpServletRequest request, HttpServletResponse response, HttpRequestMethodNotSupportedException e) {
        String errorNo = this.printError(request, response, (Throwable)e, "\u8bf7\u6c42\u65b9\u5f0f\u6709\u8bef");
        return ApiResult.fail((ApiCode)ApiCode.METHOD_NOT_SUPPORT, (String)errorNo, (String)this.stackTrace((Throwable)e), null, null);
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    @ResponseBody
    public ApiResult<String> handleHttpMediaTypeNotAcceptableException(HttpServletRequest request, HttpServletResponse response, HttpMediaTypeNotAcceptableException e) {
        String errorNo = this.printError(request, response, (Throwable)e, "\u8bf7\u6c42\u5a92\u4f53\u7c7b\u578b\u6709\u8bef");
        String errorMsg = CollUtil.isEmpty((Collection)e.getSupportedMediaTypes()) ? "\u4e0d\u652f\u6301\u7684Content-Type" : "\u4ec5\u652f\u6301\u4ee5\u4e0bContent-Type:" + MediaType.toString((Collection)e.getSupportedMediaTypes());
        return ApiResult.fail((ApiCode)ApiCode.UNSUPPORTED_MEDIA_TYPE, (String)errorNo, (String)this.stackTrace((Throwable)e), null, (String)errorMsg);
    }

    @ExceptionHandler(value={HttpClientErrorException.class})
    @ResponseBody
    public ApiResult<String> handleHttpClientErrorException(HttpServletRequest request, HttpServletResponse response, HttpClientErrorException e) {
        String errorNo = this.printError(request, response, (Throwable)e, "\u5ba2\u6237\u7aef\u8bf7\u6c42\u5f02\u5e38");
        String msg = null;
        if (e.getStatusCode() == HttpStatus.UNAUTHORIZED) {
            msg = "\u6682\u672a\u767b\u5f55\u6216token\u5df2\u7ecf\u8fc7\u671f";
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
        }
        return ApiResult.fail((int)e.getRawStatusCode(), (String)errorNo, (String)this.stackTrace((Throwable)e), null, (String)msg);
    }

    @ExceptionHandler(value={IllegalArgumentException.class, MethodArgumentNotValidException.class, MissingServletRequestParameterException.class, ConstraintViolationException.class, ValidationException.class})
    @ResponseBody
    public ApiResult<String> handleArgumentInvalidException(HttpServletRequest request, HttpServletResponse response, Exception exception) {
        String errorNo = this.printError(request, response, exception, "\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7");
        if (exception instanceof IllegalArgumentException) {
            return ApiResult.fail((ApiCode)ApiCode.PARAMETER_EXCEPTION, (String)errorNo, null, null, (String)exception.getMessage());
        }
        if (exception instanceof MethodArgumentNotValidException) {
            String msg = ((MethodArgumentNotValidException)exception).getBindingResult().getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(";"));
            return ApiResult.fail((ApiCode)ApiCode.PARAMETER_EXCEPTION, (String)errorNo, null, null, (String)msg);
        }
        if (exception instanceof MissingServletRequestParameterException) {
            String field = ((MissingServletRequestParameterException)exception).getParameterName();
            return ApiResult.fail((ApiCode)ApiCode.PARAMETER_EXCEPTION, (String)errorNo, null, null, (String)(field + "\u4e3a\u7a7a"));
        }
        if (exception instanceof ConstraintViolationException) {
            String msg = ((ConstraintViolationException)exception).getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(";"));
            return ApiResult.fail((ApiCode)ApiCode.PARAMETER_EXCEPTION, (String)errorNo, null, null, (String)msg);
        }
        if (exception instanceof ValidationException) {
            return ApiResult.fail((ApiCode)ApiCode.PARAMETER_EXCEPTION, (String)errorNo, null, null, (String)exception.getMessage());
        }
        return ApiResult.fail((ApiCode)ApiCode.PARAMETER_EXCEPTION, (String)errorNo, null, null, (String)ExceptionUtil.getRootCause((Throwable)exception).getMessage());
    }

    @ExceptionHandler(value={BusinessException.class})
    @ResponseBody
    public ApiResult<String> handleBusinessException(HttpServletRequest request, HttpServletResponse response, BusinessException e) {
        ApiResult<String> result = this.customTranslate(request, response, (Throwable)e);
        if (result != null) {
            return result;
        }
        String errorNo = this.printError(request, response, (Throwable)e, "\u4e1a\u52a1\u5f02\u5e38");
        if (e.getCode() != null) {
            return ApiResult.fail((int)e.getCode(), (String)errorNo, (String)this.stackTrace((Throwable)e), null, (String)e.getMessage());
        }
        ApiCode apiCode = e.getApiCode();
        if (apiCode == null) {
            apiCode = ApiCode.FAIL;
        } else if (apiCode.getCode() == HttpStatus.UNAUTHORIZED.value()) {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
        }
        return ApiResult.fail((ApiCode)apiCode, (String)errorNo, (String)this.stackTrace((Throwable)e), null, (String)e.getMessage());
    }

    @ExceptionHandler(value={ResourceAccessException.class})
    @ResponseBody
    public ApiResult<String> handleResourceAccessException(HttpServletRequest request, HttpServletResponse response, ResourceAccessException e) {
        String errorNo = this.printError(request, response, (Throwable)e, "\u8bf7\u6c42\u8d44\u6e90\u5f02\u5e38");
        return ApiResult.fail((ApiCode)ApiCode.SYSTEM_EXCEPTION, (String)errorNo, (String)this.stackTrace((Throwable)e), null, null);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ApiResult<String> handleException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
        if (rootCause instanceof BusinessException) {
            return this.handleBusinessException(request, response, (BusinessException)rootCause);
        }
        if (rootCause instanceof IllegalArgumentException) {
            return this.handleArgumentInvalidException(request, response, (Exception)rootCause);
        }
        ApiResult<String> result = this.customTranslate(request, response, (Throwable)ObjectUtil.defaultIfNull((Object)rootCause, (Object)e));
        if (result != null) {
            return result;
        }
        String errorNo = this.printError(request, response, e, "\u7cfb\u7edf\u5f02\u5e38");
        return ApiResult.fail((ApiCode)ApiCode.SYSTEM_EXCEPTION, (String)errorNo, (String)this.stackTrace(e), null, null);
    }

    private ApiResult<String> customTranslate(HttpServletRequest request, HttpServletResponse response, Throwable e) {
        if (this.exceptionTranslates == null) {
            ObjectProvider translates = SpringContextHolder.getObjectProvider(CustomExceptionTranslate.class);
            this.exceptionTranslates = new ArrayList<CustomExceptionTranslate>(8);
            for (CustomExceptionTranslate translate : translates) {
                this.exceptionTranslates.add(translate);
            }
        }
        if (this.exceptionTranslates.isEmpty()) {
            return null;
        }
        for (CustomExceptionTranslate exceptionTranslate : this.exceptionTranslates) {
            ApiResult apiResult;
            if (!exceptionTranslate.support(e) || (apiResult = exceptionTranslate.translate(e)) == null) continue;
            if (apiResult.getCode() == ApiCode.UNAUTHORIZED.getCode()) {
                response.setStatus(apiResult.getCode());
            }
            if (apiResult.getErrorNo() == null) {
                String errorNo = this.printError(request, response, e, exceptionTranslate.getClass().getName() + "\u5904\u7406\u5f02\u5e38");
                apiResult.setErrorNo(errorNo);
            }
            if (apiResult.getData() == null) {
                apiResult.setData((Object)this.stackTrace(e));
            }
            return apiResult;
        }
        return null;
    }

    private String printError(HttpServletRequest request, HttpServletResponse response, Throwable throwable, String description) {
        response.setContentType("application/json");
        String errorNo = FORMATTER.format(LocalDateTime.now());
        log.error("\u8bf7\u6c42\u5730\u5740\uff1a{}, {}", (Object)request.getRequestURL(), (Object)request.getQueryString());
        String msg = description + "\uff0c\u9519\u8bef\u53f7\uff1a" + errorNo;
        log.error(msg, throwable);
        return errorNo;
    }

    private String stackTrace(Throwable throwable) {
        if (!this.exceptionToData()) {
            return null;
        }
        return ExceptionUtil.stacktraceToString((Throwable)throwable, (int)-1);
    }

    private boolean exceptionToData() {
        Boolean toData = this.exceptionProperties.getGlobal().getExceptionDetailToData();
        return toData != null && toData != false;
    }
}

