/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.formatter;

import com.elitescloud.boot.web.formatter.BigDecimalFormat;
import com.elitescloud.boot.web.formatter.BigDecimalType;
import com.elitescloud.boot.web.formatter.BigDecimalTypeConfig;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class BigDecimalFormatAspect {
    private static final Logger log = LoggerFactory.getLogger(BigDecimalFormatAspect.class);
    private static final Map<Class<?>, Field[]> classFieldsCache = new HashMap();
    private final BigDecimalTypeConfig bigDecimalTypeConfig;

    public BigDecimalFormatAspect(BigDecimalTypeConfig bigDecimalTypeConfig) {
        this.bigDecimalTypeConfig = bigDecimalTypeConfig;
    }

    @Around(value="@within(org.springframework.web.bind.annotation.RestController) || @annotation(org.springframework.web.bind.annotation.ResponseBody)")
    public Object aroundControllerResponse(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result = joinPoint.proceed();
        try {
            Object data;
            if (result != null && result instanceof ApiResult && (data = ((ApiResult)result).getData()) != null) {
                if (data instanceof PagingVO) {
                    this.getListFieldValue(((PagingVO)data).getRecords());
                } else if (data instanceof Collection) {
                    this.getListFieldValue((List)data);
                } else {
                    this.getFieldValue(data);
                }
            }
        }
        catch (Exception e) {
            log.error("BigDecimalFormatAspect \u683c\u5f0f\u5316\u5f02\u5e38\uff1a" + e.getMessage());
            return result;
        }
        return result;
    }

    private void getListFieldValue(List dataList) throws IllegalAccessException {
        if (dataList == null) {
            return;
        }
        for (Object od : dataList) {
            this.getFieldValue(od);
        }
    }

    private void getFieldValue(Object result) throws IllegalAccessException {
        Field[] fields;
        if (result == null) {
            return;
        }
        Class<?> resultClass = result.getClass();
        for (Field field : fields = classFieldsCache.computeIfAbsent(resultClass, cls -> resultClass.getDeclaredFields())) {
            if (!field.isAnnotationPresent(BigDecimalFormat.class) || field.getType() != BigDecimal.class) continue;
            BigDecimalFormat annotation = field.getAnnotation(BigDecimalFormat.class);
            field.setAccessible(true);
            BigDecimal value = (BigDecimal)field.get(result);
            if (value == null) continue;
            BigDecimal scaledValue = value;
            if (annotation.bdType() != null && !annotation.bdType().name().equals(BigDecimalType.CUSTOM.name())) {
                if (annotation.bdType().equals((Object)BigDecimalType.AMOUNT)) {
                    scaledValue = value.setScale(this.bigDecimalTypeConfig.getAmountScale(), RoundingMode.valueOf(this.bigDecimalTypeConfig.getAmountRoundingMode()));
                }
                if (annotation.bdType().equals((Object)BigDecimalType.PRICE)) {
                    scaledValue = value.setScale(this.bigDecimalTypeConfig.getPriceScale(), RoundingMode.valueOf(this.bigDecimalTypeConfig.getPriceRoundingMode()));
                }
                if (annotation.bdType().equals((Object)BigDecimalType.QUANTITY)) {
                    scaledValue = value.setScale(this.bigDecimalTypeConfig.getQuantityScale(), RoundingMode.valueOf(this.bigDecimalTypeConfig.getQuantityRoundingMode()));
                }
            } else {
                scaledValue = value.setScale(annotation.scale(), annotation.roundingMode());
            }
            field.set(result, scaledValue);
        }
    }
}

