/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.config.trace;

import cn.hutool.core.lang.UUID;
import com.elitescloud.boot.base.AbstractLogTraceHandler;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.MDC;

public class ServletWebLogTraceHandler
extends AbstractLogTraceHandler
implements Filter {
    public ServletWebLogTraceHandler(String traceIdPrefix) {
        super(traceIdPrefix);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String traceId = request.getHeader("cloudt_traceId");
        this.putTraceId(traceId);
        this.putRequestId(request);
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private void putRequestId(HttpServletRequest request) {
        String requestId = request.getHeader("requestId");
        if (requestId == null) {
            requestId = UUID.randomUUID().toString();
        }
        MDC.put((String)"requestId", (String)requestId);
    }
}

