package com.elitescloud.boot.webservice.support;

import com.elitescloud.cloudt.common.base.annotation.webservice.WebServiceProvider;
import org.springframework.lang.NonNull;

/**
 * 服务发布者配置.
 * <p>
 * 寻找带有{@link WebServiceProvider}注解的SpringBean进行自动发布服务。
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/10
 */
public interface ServiceProviderConfig {

    /**
     * 发布服务
     *
     * @param bean               bean对象
     * @param beanName           bean名称
     * @param webServiceProvider bean的注解
     */
    void publishService(@NonNull Object bean, String beanName, @NonNull WebServiceProvider webServiceProvider);
}
