package com.elitescloud.boot.webservice;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.CustomExceptionTranslate;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.support.LogStartedInfo;
import com.elitescloud.boot.webservice.support.ServiceProviderConfig;
import lombok.extern.log4j.Log4j2;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

import javax.ws.rs.BadRequestException;

/**
 * WebService自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/10
 */
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties(WebServiceProperties.class)
@Log4j2
public class WebServiceAutoConfiguration {

    public WebServiceAutoConfiguration() {
        log.info("启用WebService");
    }

    /**
     * 启动日志信息
     *
     * @param provider
     * @return
     */
    @Bean
    public LogStartedInfo logStartedInfoWebService(ServiceProviderConfig provider) {
        return new LogStartedInfo() {
            @Override
            public void print(String uriPrefix) {
                String webserviceApiUri = generateWebServiceUri(uriPrefix);
                if (StringUtils.hasText(webserviceApiUri)) {
                    log.info("可访问WebService API：{}", webserviceApiUri);
                }
            }

            private String generateWebServiceUri(String uriPrefix) {
                if (provider != null) {
                    var webServiceProperties = SpringContextHolder.getBean(WebServiceProperties.class);
                    return (uriPrefix.endsWith("/") ? uriPrefix.substring(0, uriPrefix.length() - 1) : uriPrefix) + webServiceProperties.getServicePath();
                }

                return null;
            }

        };
    }

    /**
     * WebService异常
     *
     * @return 异常
     */
    @Bean
    public CustomExceptionTranslate exceptionTranslateWebService() {
        return new CustomExceptionTranslate() {
            @Override
            public boolean support(@NonNull Throwable e) {
                return e instanceof BadRequestException;
            }

            @Override
            public ApiResult<String> translate(@NonNull Throwable e) {
                return ApiResult.fail(ApiCode.BAD_REQUEST, "WebService请求异常");
            }
        };
    }
}
