/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.webservice.support;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.webservice.WebServiceProperties;
import com.elitescloud.boot.webservice.support.ServiceConsumerConfig;
import com.elitescloud.cloudt.common.base.annotation.webservice.WebServiceConsumer;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.lang.NonNull;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractServiceConsumerConfig
implements ServiceConsumerConfig,
EnvironmentAware,
BeanDefinitionRegistryPostProcessor {
    private static final Logger log = LogManager.getLogger(AbstractServiceConsumerConfig.class);
    protected ConfigurableListableBeanFactory beanFactory;
    protected Environment environment;
    private WebServiceProperties properties;

    public void setEnvironment(@NonNull Environment environment) {
        this.environment = environment;
    }

    public void postProcessBeanFactory(@NonNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void postProcessBeanDefinitionRegistry(@NonNull BeanDefinitionRegistry registry) throws BeansException {
        Set<String> consumerPackages = this.getProperties().getConsumerPackages();
        if (CollectionUtils.isEmpty(consumerPackages)) {
            return;
        }
        Set<BeanDefinition> definitions = this.scanConsumer(consumerPackages);
        for (BeanDefinition definition : definitions) {
            Class<?> serviceClass = null;
            try {
                serviceClass = Class.forName(definition.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            WebServiceConsumer consumer = serviceClass.getAnnotation(WebServiceConsumer.class);
            String beanName = this.generateBeanName(definition, consumer);
            Object bean = this.buildConsumer(serviceClass, beanName, consumer);
            registry.registerBeanDefinition(beanName, this.buildBeanDefinition(serviceClass, bean));
            log.info("\u6ce8\u518cWebService\u5ba2\u6237\u7aefBean\uff1a{}, \u670d\u52a1\u63a5\u53e3\uff1a{}", (Object)beanName, (Object)serviceClass.getName());
        }
    }

    protected WebServiceProperties getProperties() {
        BindResult bindResult;
        if (this.properties == null && (bindResult = Binder.get((Environment)this.environment).bind("elitesland.webservice", WebServiceProperties.class)).isBound()) {
            this.properties = (WebServiceProperties)bindResult.get();
        }
        return this.properties;
    }

    protected String getConfigAddress(String addressKey) {
        for (WebServiceProperties.ConsumerAddress consumerAddress : this.getProperties().getConsumerAddresses()) {
            if (!CharSequenceUtil.equals((CharSequence)addressKey, (CharSequence)consumerAddress.getAddressKey())) continue;
            return consumerAddress.getAddress();
        }
        return null;
    }

    private BeanDefinition buildBeanDefinition(Class<?> serviceClass, Object bean) {
        GenericBeanDefinition beanDefinition = (GenericBeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(serviceClass).getRawBeanDefinition();
        beanDefinition.setBeanClass(ServiceConsumerFactory.class);
        beanDefinition.getConstructorArgumentValues().addGenericArgumentValue(serviceClass);
        beanDefinition.getConstructorArgumentValues().addGenericArgumentValue(bean);
        beanDefinition.setAutowireMode(2);
        return beanDefinition;
    }

    private String generateBeanName(BeanDefinition beanDefinition, WebServiceConsumer consumer) {
        if (StringUtils.hasText((String)consumer.beanName())) {
            return consumer.beanName();
        }
        return beanDefinition.getBeanClassName() + "WsProxy";
    }

    private Set<BeanDefinition> scanConsumer(Set<String> basePackages) {
        HashSet<BeanDefinition> consumers = new HashSet<BeanDefinition>();
        CustomClassPathScanningCandidateComponentProvider componentProvider = new CustomClassPathScanningCandidateComponentProvider();
        componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(WebServiceConsumer.class));
        for (String basePackage : basePackages) {
            Set beanDefinitions = componentProvider.findCandidateComponents(basePackage.replace(".", "/"));
            consumers.addAll(beanDefinitions);
        }
        return consumers;
    }

    static class ServiceConsumerFactory<T>
    implements FactoryBean<T> {
        private final Class<T> serviceType;
        private final Object proxy;

        public ServiceConsumerFactory(Class<T> serviceType, Object proxy) {
            this.serviceType = serviceType;
            this.proxy = proxy;
        }

        public T getObject() throws Exception {
            return (T)this.proxy;
        }

        public Class<?> getObjectType() {
            return this.serviceType;
        }
    }

    static class CustomClassPathScanningCandidateComponentProvider
    extends ClassPathScanningCandidateComponentProvider {
        public CustomClassPathScanningCandidateComponentProvider() {
            super(false);
        }

        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            return true;
        }
    }
}

