package com.elitescloud.boot.webservice.support.cxf;

import com.elitescloud.cloudt.common.base.annotation.webservice.WebServiceProvider;
import com.elitescloud.boot.webservice.support.AbstractServiceProviderConfig;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.spring.boot.autoconfigure.CxfProperties;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;

import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/10
 */
@ConditionalOnClass(SpringBus.class)
public class CxfServiceProviderConfig extends AbstractServiceProviderConfig {

    private final CxfProperties cxfProperties;
    private final SpringBus springBus;

    public CxfServiceProviderConfig(CxfProperties cxfProperties, SpringBus springBus) {
        this.cxfProperties = cxfProperties;
        this.springBus = springBus;
    }

    @Bean("cxfServletRegistration")
    public ServletRegistrationBean<CXFServlet> cxfServletRegistration() {
        String path = properties.getServicePath();

        String urlMapping = path.endsWith("/") ? path + "*" : path + "/*";
        ServletRegistrationBean<CXFServlet> registration = new ServletRegistrationBean<>(
                new CXFServlet(), urlMapping);
        CxfProperties.Servlet servletProperties = this.cxfProperties.getServlet();
        registration.setLoadOnStartup(servletProperties.getLoadOnStartup());
        for (Map.Entry<String, String> entry : servletProperties.getInit().entrySet()) {
            registration.addInitParameter(entry.getKey(), entry.getValue());
        }
        return registration;
    }

    @Override
    public void publishService(Object bean, String beanName, WebServiceProvider webServiceProvider) {
        EndpointImpl endpoint = new EndpointImpl(springBus, bean);
        endpoint.publish(webServiceProvider.path());
    }
}
