package com.elitescloud.boot.webservice.support;

import com.elitescloud.cloudt.common.base.annotation.webservice.WebServiceConsumer;
import org.springframework.lang.NonNull;

/**
 * 服务消费者配置.
 * <p>
 * 寻找带有{@link WebServiceConsumer}注解的接口，自动生成SpringBean，支持业务使用的地方进行注入。
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/10
 */
public interface ServiceConsumerConfig {

    /**
     * 注册消费者
     *
     * @param serviceClass 服务接口
     * @param beanName     注册的bean名称
     * @param consumer     接口上的注解
     */
    Object buildConsumer(@NonNull Class<?> serviceClass, String beanName, @NonNull WebServiceConsumer consumer);
}
