/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.websocket.config;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.provider.UserDetailProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.websocket.CloudtWebSocketHandler;
import com.elitescloud.boot.websocket.CloudtWebSocketTemplate;
import com.elitescloud.boot.websocket.config.CloudtWebSocketProperties;
import com.elitescloud.boot.websocket.config.CloudtWebSocketRedisAutoConfiguration;
import com.elitescloud.boot.websocket.endpoint.EndpointPathParamConvert;
import com.elitescloud.boot.websocket.endpoint.WebSocketEndpoint;
import com.elitescloud.boot.websocket.handler.WebSocketMsgPublishable;
import com.elitescloud.boot.websocket.support.AuthHandshakeInterceptor;
import com.elitescloud.boot.websocket.support.CloudtWebSocketHandlerDelegate;
import com.elitescloud.boot.websocket.support.redis.RedisWebSocketMsgPublishable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.EndpointConverter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.lang.NonNull;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.server.standard.ServletServerContainerFactoryBean;

@EnableConfigurationProperties(value={CloudtWebSocketProperties.class})
@AutoConfigureAfter(value={CloudtWebSocketRedisAutoConfiguration.class})
@EnableWebSocket
public class CloudtWebSocketAutoConfiguration
implements WebSocketConfigurer {
    private static final Logger log = LoggerFactory.getLogger(CloudtWebSocketAutoConfiguration.class);
    private final ObjectProvider<CloudtWebSocketHandler> handlerObjectProvider;
    private final UserDetailProvider userDetailProvider;

    public CloudtWebSocketAutoConfiguration(ObjectProvider<CloudtWebSocketHandler> handlerObjectProvider, UserDetailProvider userDetailProvider) {
        this.handlerObjectProvider = handlerObjectProvider;
        this.userDetailProvider = userDetailProvider;
    }

    public void registerWebSocketHandlers(@NonNull WebSocketHandlerRegistry registry) {
        for (CloudtWebSocketHandler handler : this.handlerObjectProvider) {
            Assert.notEmpty((Object[])handler.paths(), (String)(handler.getClass().getName() + "\u7684paths\u4e3a\u7a7a"), (Object[])new Object[0]);
            registry.addHandler(new CloudtWebSocketHandlerDelegate(handler, this.userDetailProvider), handler.paths()).addInterceptors(new HandshakeInterceptor[]{new AuthHandshakeInterceptor(this.userDetailProvider)}).setAllowedOrigins(handler.allowedOrigins()).setAllowedOriginPatterns(handler.allowedOriginPatterns());
            log.info("registered WebSocketHandler\uff1a{}", (Object)handler.getClass().getName());
        }
    }

    @Bean
    public ServletServerContainerFactoryBean servletServerContainerFactoryBean(CloudtWebSocketProperties properties) {
        ServletServerContainerFactoryBean container = new ServletServerContainerFactoryBean();
        if (properties.getMaxTextMessageBufferSize() != null) {
            container.setMaxTextMessageBufferSize(Integer.valueOf((int)properties.getMaxTextMessageBufferSize().toBytes()));
        }
        if (properties.getMaxBinaryMessageBufferSize() != null) {
            container.setMaxBinaryMessageBufferSize(Integer.valueOf((int)properties.getMaxBinaryMessageBufferSize().toBytes()));
        }
        if (properties.getAsyncSendTimeout() != null) {
            container.setAsyncSendTimeout(Long.valueOf(properties.getAsyncSendTimeout().toMillis()));
        }
        if (properties.getMaxSessionIdleTimeout() != null) {
            container.setMaxSessionIdleTimeout(Long.valueOf(properties.getMaxSessionIdleTimeout().toMillis()));
        }
        return container;
    }

    @Bean
    public CloudtWebSocketTemplate cloudtWebSocketTemplate(ObjectProvider<WebSocketMsgPublishable> msgPublishables) {
        return new CloudtWebSocketTemplate((WebSocketMsgPublishable)msgPublishables.getIfAvailable());
    }

    @Bean
    public WebSocketMsgPublishable redisWebSocketMsgPublishable(RedisUtils redisUtils) {
        return new RedisWebSocketMsgPublishable(redisUtils);
    }

    @Bean
    public WebSocketEndpoint webSocketEndpoint() {
        return new WebSocketEndpoint();
    }

    @Bean
    @EndpointConverter
    public EndpointPathParamConvert endpointPathParamConvert() {
        return new EndpointPathParamConvert();
    }
}

