package com.elitescloud.boot.websocket.endpoint;

import com.elitescloud.boot.common.constant.EndpointConstant;
import com.elitescloud.boot.websocket.support.WebSocketSessionManager;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.lang.Nullable;

import java.util.HashMap;
import java.util.Map;

/**
 * websocket信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/6/2
 */
@Endpoint(id = EndpointConstant.PREFIX + "-websocket")
public class WebSocketEndpoint {

    /**
     * 统计在线用户数
     *
     * @return 用户数
     */
    @ReadOperation
    public Map<String, Object> onlineNum() {
        var num = WebSocketSessionManager.countSession();
        Map<String, Object> result = new HashMap<>(4);
        result.put("onlineNum", num);
        return result;
    }


    /**
     * 获取在线用户
     *
     * @return 用户数
     */
    @ReadOperation
    public Map<String, Object> onlineUser(@Selector @Nullable EndpointPathParam pathParam, @Nullable String username) {
        Map<String, Object> result = new HashMap<>(4);
//        if (args.length == 0) {
//            return result;
//        } else if (args.length == 1) {
//            result.put("onlineUsers", WebSocketSessionManager.onlineUsers());
//        } else {
//            var sessions = WebSocketSessionManager.getSession(args[1]);
//            result.put("onlineUserDetail", sessions);
//        }
        return result;
    }
}
