package com.elitescloud.boot.websocket.support.redis;

import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.websocket.handler.WebSocketMsgPublishable;

/**
 * 基于redis的消息发布.
 *
 * @author Kaiser（wang shao）
 * @date 2023/6/2
 */
public class RedisWebSocketMsgPublishable implements WebSocketMsgPublishable {

    private final RedisUtils redisUtils;

    public RedisWebSocketMsgPublishable(RedisUtils redisUtils) {
        this.redisUtils = redisUtils;
    }

    @Override
    public void publish(String msg, String... account) {
        redisUtils.publishMessage(WebSocketRedisConstant.CHANNEL, new RedisWebSocketMsg(msg, account));
    }
}
