package com.elitescloud.boot.websocket.util;

import com.elitescloud.boot.util.ObjectMapperFactory;
import com.elitescloud.boot.websocket.model.WebSocketResult;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.TextMessage;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * WebSocket工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/31
 */
public class WebSocketUtil {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.instance();
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketUtil.class);

    private WebSocketUtil() {
    }

    /**
     * 转为文本消息
     *
     * @param success 是否成功
     * @param msg     提示消息
     * @param data    数据
     * @return 文本消息
     */
    public static <T extends Serializable> TextMessage convertTextMessage(boolean success, String msg, T data) {
        msg = StringUtils.hasText(msg) ? msg : (success ? "操作成功" : "操作失败");

        WebSocketResult<T> result = new WebSocketResult<>();
        result.setSuccess(success);
        result.setMsg(msg);
        result.setData(data);

        return convertTextMessage(result);
    }

    /**
     * 转为文本消息
     *
     * @param apiResult API结果
     * @return 文本消息
     */
    public static <T extends Serializable> TextMessage convertTextMessage(@NotNull ApiResult<T> apiResult) {
        var msg = StringUtils.hasText(apiResult.getMsg()) ? apiResult.getMsg() : (apiResult.isSuccess() ? "操作成功" : "操作失败");

        WebSocketResult<T> result = new WebSocketResult<>();
        result.setSuccess(apiResult.isSuccess());
        result.setMsg(msg);
        result.setData(apiResult.getData());

        return convertTextMessage(result);
    }

    /**
     * 转为文本消息
     *
     * @param result 结果
     * @return 文本消息
     */
    public static <T extends Serializable> TextMessage convertTextMessage(@NotNull WebSocketResult<T> result) {
        try {
            return new TextMessage(OBJECT_MAPPER.writeValueAsString(result));
        } catch (JsonProcessingException e) {
            LOG.error("转换消息异常:", e);
        }
        return new TextMessage("系统异常");
    }
}
