package com.elitescloud.boot;

import com.elitescloud.boot.support.CloudtBeanNameGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/4/21
 */
class CloudtContextApplicationRunListener implements SmartApplicationListener {

    @Override
    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType.isAssignableFrom(ApplicationStartingEvent.class);
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationStartingEvent) {
            onApplicationStarting((ApplicationStartingEvent) event);
        }
    }

    private void onApplicationStarting(ApplicationStartingEvent event) {
        SpringApplication application = event.getSpringApplication();
        application.setBeanNameGenerator(CloudtBeanNameGenerator.INSTANCE);
    }
}
