package com.elitescloud.boot.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

/**
 * 网络工具类.
 *
 * @author Kaiser（wang shao）
 * @date 3/20/2023
 */
public class NetUtil {
    private NetUtil() {
    }

    /**
     * 获取本机IP
     *
     * @return IP地址
     */
    public static String currentIp() {
        var address = getCurrentServerAddress();
        return address == null ? null : address.getHostAddress();
    }

    /**
     * 解析本机地址
     *
     * @return 地址
     */
    private static InetAddress getCurrentServerAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!inetAddress.isLinkLocalAddress() && !inetAddress.isLoopbackAddress() && inetAddress instanceof Inet4Address) {
                        return inetAddress;
                    }
                }
            }

            return InetAddress.getLocalHost();
        } catch (Exception e) {
            throw new IllegalStateException("解析IP异常", e);
        }
    }
}
