package com.elitescloud.boot.exception;

import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

/**
 * 自定义错误翻译.
 * <p>
 * 对于第三方框架的异常翻译及自定义异常翻译
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/3
 */
public interface CustomExceptionTranslate {

    /**
     * 是否支持翻译
     *
     * @return 是否支持
     */
    boolean support(@NonNull Throwable e);

    /**
     * 异常翻译
     *
     * @param e   异常
     * @return 返回结果，为空时进入下一个翻译
     */
    @Nullable
    ApiResult<String> translate(@NonNull Throwable e);
}
